/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.query.AbstractMapperQuery;
import org.jnosql.artemis.document.query.ArtemisDocumentQuery;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DocumentFrom;
import org.jnosql.diana.api.document.query.DocumentLimit;
import org.jnosql.diana.api.document.query.DocumentNameCondition;
import org.jnosql.diana.api.document.query.DocumentNameOrder;
import org.jnosql.diana.api.document.query.DocumentNotCondition;
import org.jnosql.diana.api.document.query.DocumentOrder;
import org.jnosql.diana.api.document.query.DocumentSkip;
import org.jnosql.diana.api.document.query.DocumentWhere;

class DefaultDocumentMapperSelectBuilder
extends AbstractMapperQuery
implements DocumentFrom,
DocumentLimit,
DocumentSkip,
DocumentOrder,
DocumentNameCondition,
DocumentNotCondition,
DocumentNameOrder,
DocumentWhere {
    private final List<Sort> sorts = new ArrayList<Sort>();

    DefaultDocumentMapperSelectBuilder(ClassRepresentation representation, Converters converters) {
        super(representation, converters);
    }

    public DocumentNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public DocumentNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public DocumentNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentSkip skip(long start) {
        this.start = start;
        return this;
    }

    public DocumentLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public DocumentOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> DocumentWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public DocumentWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> DocumentWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> DocumentWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> DocumentWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> DocumentWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> DocumentWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> DocumentWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public DocumentNameOrder asc() {
        this.sorts.add(Sort.of((String)this.representation.getColumnField(this.name), (Sort.SortType)Sort.SortType.ASC));
        return this;
    }

    public DocumentNameOrder desc() {
        this.sorts.add(Sort.of((String)this.representation.getColumnField(this.name), (Sort.SortType)Sort.SortType.DESC));
        return this;
    }

    public DocumentQuery build() {
        return new ArtemisDocumentQuery(this.sorts, this.limit, this.start, this.condition, this.documentCollection);
    }
}

