/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.Param;
import org.jnosql.artemis.PreparedStatementAsync;
import org.jnosql.artemis.Query;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.document.query.DocumentRepositoryType;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentRepositoryAsyncProxy<T>
implements InvocationHandler {
    protected abstract RepositoryAsync getRepository();

    protected abstract DocumentQueryParser getQueryParser();

    protected abstract DocumentTemplateAsync getTemplate();

    protected abstract DocumentQueryDeleteParser getDeleteParser();

    protected abstract ClassRepresentation getClassRepresentation();

    protected abstract Converters getConverters();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class typeClass = this.getClassRepresentation().getClassInstance();
        DocumentRepositoryType type = DocumentRepositoryType.of(method, args);
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQueryParser().parse(methodName, args, this.getClassRepresentation(), this.getConverters());
                return this.executeQuery(this.getCallBack(args), query);
            }
            case FIND_ALL: {
                return this.executeQuery(this.getCallBack(args), DocumentQueryBuilder.select().from(this.getClassRepresentation().getName()).build());
            }
            case DELETE_BY: {
                DocumentDeleteQuery deleteQuery = this.getDeleteParser().parse(methodName, args, this.getClassRepresentation(), this.getConverters());
                return this.executeDelete(args, deleteQuery);
            }
            case QUERY: {
                DocumentQuery documentQuery = DocumentRepositoryType.getQuery(args).get();
                return this.executeQuery(this.getCallBack(args), documentQuery);
            }
            case QUERY_DELETE: {
                return this.executeDelete(args, DocumentRepositoryType.getDeleteQuery(args).get());
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                return this.getJnosqlQuery(method, args, typeClass);
            }
        }
        return Void.class;
    }

    private Object executeDelete(Object[] args, DocumentDeleteQuery query1) {
        Object callBack = this.getCallBack(args);
        if (Consumer.class.isInstance(callBack)) {
            this.getTemplate().delete(query1, (Consumer)Consumer.class.cast(callBack));
        } else {
            this.getTemplate().delete(query1);
        }
        return Void.class;
    }

    private Object getCallBack(Object[] args) {
        return args[args.length - 1];
    }

    private Object executeQuery(Object arg, DocumentQuery query) {
        if (!Consumer.class.isInstance(arg)) {
            throw new DynamicQueryException("On select async method you must put a java.util.function.Consumer as end parameter as callback");
        }
        this.getTemplate().select(query, (Consumer)Consumer.class.cast(arg));
        return Void.class;
    }

    private Object getJnosqlQuery(Method method, Object[] args, Class<?> typeClass) {
        String value = method.getAnnotation(Query.class).value();
        Map<String, Object> params = this.getParams(method, args);
        Consumer<List<T>> consumer = this.getConsumer(args);
        if (params.isEmpty()) {
            this.getTemplate().query(value, consumer);
        } else {
            PreparedStatementAsync prepare = this.getTemplate().prepare(value);
            params.entrySet().stream().forEach(e -> prepare.bind((String)e.getKey(), e.getValue()));
            prepare.getResultList(consumer);
        }
        return Void.class;
    }

    private Consumer<List<T>> getConsumer(Object[] args) {
        Object callBack = this.getCallback(args);
        Consumer consumer = callBack instanceof Consumer ? (Consumer)Consumer.class.cast(callBack) : l -> {};
        return consumer;
    }

    private Map<String, Object> getParams(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            Param param = parameter.getAnnotation(Param.class);
            if (!Objects.nonNull(param)) continue;
            params.put(param.value(), args[index]);
        }
        return params;
    }

    private Object getCallback(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }
}

