/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.artemis.IdNotFoundException;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.Reflections;

public abstract class AbstractDocumentRepositoryAsync<T, ID>
implements RepositoryAsync<T, ID> {
    protected abstract DocumentTemplateAsync getTemplate();

    protected abstract Reflections getReflections();

    protected abstract ClassRepresentation getClassRepresentation();

    public <S extends T> void save(S entity) {
        Objects.requireNonNull(entity, "Entity is required");
        Object id = this.getReflections().getValue(entity, this.getIdField().getNativeField());
        if (Objects.isNull(id)) {
            this.getTemplate().insert(entity);
            return;
        }
        Consumer<Boolean> callBack = exist -> {
            if (exist.booleanValue()) {
                this.getTemplate().update(entity);
            } else {
                this.getTemplate().insert(entity);
            }
        };
        this.existsById(id, callBack);
    }

    public <S extends T> void save(Iterable<S> entities) {
        Objects.requireNonNull(entities, "entities is required");
        entities.forEach(this::save);
    }

    public void deleteById(ID id) {
        Objects.requireNonNull(id, "is is required");
        this.getTemplate().delete(this.getEntityClass(), id);
    }

    public void existsById(ID id, Consumer<Boolean> callBack) {
        Consumer<Optional<T>> as = o -> callBack.accept(o.isPresent());
        this.findById(id, as);
    }

    public void findById(ID id, Consumer<Optional<T>> callBack) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(callBack, "callBack is required");
        this.getTemplate().find(this.getEntityClass(), id, callBack);
    }

    public void count(Consumer<Long> callback) {
        this.getTemplate().count(this.getEntityClass(), callback);
    }

    private Class<T> getEntityClass() {
        return this.getClassRepresentation().getClassInstance();
    }

    private FieldRepresentation getIdField() {
        return (FieldRepresentation)this.getClassRepresentation().getId().orElseThrow(IdNotFoundException.KEY_NOT_FOUND_EXCEPTION_SUPPLIER);
    }
}

