/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Optional;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.diana.api.document.DocumentObserverParser;

final class DocumentMapperObserver
implements DocumentObserverParser {
    private final ClassRepresentations representations;

    DocumentMapperObserver(ClassRepresentations representations) {
        this.representations = representations;
    }

    public String fireEntity(String entity) {
        Optional<ClassRepresentation> classRepresentation = this.getClassRepresentation(entity);
        return classRepresentation.map(ClassRepresentation::getName).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<ClassRepresentation> classRepresentation = this.getClassRepresentation(entity);
        return classRepresentation.map(c -> c.getColumnField(field)).orElse(field);
    }

    private Optional<ClassRepresentation> getClassRepresentation(String entity) {
        Optional bySimpleName = this.representations.findBySimpleName(entity);
        if (bySimpleName.isPresent()) {
            return bySimpleName;
        }
        Optional byClassName = this.representations.findByClassName(entity);
        return byClassName;
    }
}

