/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.AbstractDocumentTemplate;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentEventPersistManager;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateProducer;
import org.jnosql.artemis.document.DocumentWorkflow;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.diana.api.document.DocumentCollectionManager;

@ApplicationScoped
class DefaultDocumentTemplateProducer
implements DocumentTemplateProducer {
    @Inject
    private DocumentEntityConverter converter;
    @Inject
    private DocumentWorkflow workflow;
    @Inject
    private DocumentEventPersistManager persistManager;
    @Inject
    private ClassRepresentations classRepresentations;
    @Inject
    private Converters converters;

    DefaultDocumentTemplateProducer() {
    }

    public DocumentTemplate get(DocumentCollectionManager collectionManager) {
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        return new ProducerDocumentTemplate(this.converter, collectionManager, this.workflow, this.persistManager, this.classRepresentations, this.converters);
    }

    @Vetoed
    static class ProducerDocumentTemplate
    extends AbstractDocumentTemplate {
        private DocumentEntityConverter converter;
        private DocumentCollectionManager manager;
        private DocumentWorkflow workflow;
        private DocumentEventPersistManager persistManager;
        private Converters converters;
        private ClassRepresentations classRepresentations;

        ProducerDocumentTemplate(DocumentEntityConverter converter, DocumentCollectionManager manager, DocumentWorkflow workflow, DocumentEventPersistManager persistManager, ClassRepresentations classRepresentations, Converters converters) {
            this.converter = converter;
            this.manager = manager;
            this.workflow = workflow;
            this.persistManager = persistManager;
            this.classRepresentations = classRepresentations;
            this.converters = converters;
        }

        ProducerDocumentTemplate() {
        }

        @Override
        protected DocumentEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected DocumentCollectionManager getManager() {
            return this.manager;
        }

        @Override
        protected DocumentWorkflow getWorkflow() {
            return this.workflow;
        }

        @Override
        protected DocumentEventPersistManager getPersistManager() {
            return this.persistManager;
        }

        @Override
        protected ClassRepresentations getClassRepresentations() {
            return this.classRepresentations;
        }

        @Override
        protected Converters getConverters() {
            return this.converters;
        }
    }
}

