/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jnosql.artemis.EntityPostPersit;
import org.jnosql.artemis.EntityPrePersist;
import org.jnosql.artemis.document.DocumentDeleteQueryExecute;
import org.jnosql.artemis.document.DocumentEntityPostPersist;
import org.jnosql.artemis.document.DocumentEntityPrePersist;
import org.jnosql.artemis.document.DocumentEventPersistManager;
import org.jnosql.artemis.document.DocumentQueryExecute;
import org.jnosql.artemis.document.EntityDocumentPostPersist;
import org.jnosql.artemis.document.EntityDocumentPrePersist;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;

@ApplicationScoped
class DefaultDocumentEventPersistManager
implements DocumentEventPersistManager {
    @Inject
    private Event<DocumentEntityPrePersist> documentEntityPrePersistEvent;
    @Inject
    private Event<DocumentEntityPostPersist> documentEntityPostPersistEvent;
    @Inject
    private Event<EntityPrePersist> entityPrePersistEvent;
    @Inject
    private Event<EntityPostPersit> entityPostPersitEvent;
    @Inject
    private Event<EntityDocumentPrePersist> entityDocumentPrePersist;
    @Inject
    private Event<EntityDocumentPostPersist> entityDocumentPostPersist;
    @Inject
    private Event<DocumentQueryExecute> documentQueryExecute;
    @Inject
    private Event<DocumentDeleteQueryExecute> documentDeleteQueryExecute;

    DefaultDocumentEventPersistManager() {
    }

    @Override
    public void firePreDocument(DocumentEntity entity) {
        this.documentEntityPrePersistEvent.fire((Object)DocumentEntityPrePersist.of(entity));
    }

    @Override
    public void firePostDocument(DocumentEntity entity) {
        this.documentEntityPostPersistEvent.fire((Object)DocumentEntityPostPersist.of(entity));
    }

    @Override
    public <T> void firePreEntity(T entity) {
        this.entityPrePersistEvent.fire((Object)EntityPrePersist.of(entity));
    }

    @Override
    public <T> void firePostEntity(T entity) {
        this.entityPostPersitEvent.fire((Object)EntityPostPersit.of(entity));
    }

    @Override
    public <T> void firePreDocumentEntity(T entity) {
        this.entityDocumentPrePersist.fire((Object)EntityDocumentPrePersist.of(entity));
    }

    @Override
    public <T> void firePostDocumentEntity(T entity) {
        this.entityDocumentPostPersist.fire((Object)EntityDocumentPostPersist.of(entity));
    }

    @Override
    public void firePreQuery(DocumentQuery query) {
        this.documentQueryExecute.fire((Object)DocumentQueryExecute.of(query));
    }

    @Override
    public void firePreDeleteQuery(DocumentDeleteQuery query) {
        this.documentDeleteQueryExecute.fire((Object)DocumentDeleteQueryExecute.of(query));
    }
}

