/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DefaultDocumentFieldValue;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentFieldConverter;
import org.jnosql.artemis.document.DocumentFieldConverters;
import org.jnosql.artemis.document.DocumentFieldValue;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.FieldType;
import org.jnosql.artemis.reflection.FieldValue;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;

public abstract class AbstractDocumentEntityConverter
implements DocumentEntityConverter {
    private final DocumentFieldConverters.DocumentFieldConverterFactory converterFactory = new DocumentFieldConverters.DocumentFieldConverterFactory();

    protected abstract ClassRepresentations getClassRepresentations();

    protected abstract Reflections getReflections();

    protected abstract Converters getConverters();

    @Override
    public DocumentEntity toDocument(Object entityInstance) {
        Objects.requireNonNull(entityInstance, "Object is required");
        ClassRepresentation representation = this.getClassRepresentations().get(entityInstance.getClass());
        DocumentEntity entity = DocumentEntity.of((String)representation.getName());
        representation.getFields().stream().map(f -> this.to((FieldRepresentation)f, entityInstance)).filter(FieldValue::isNotEmpty).map(f -> f.toDocument(this, this.getConverters())).flatMap(Collection::stream).forEach(arg_0 -> ((DocumentEntity)entity).add(arg_0));
        return entity;
    }

    @Override
    public <T> T toEntity(Class<T> entityClass, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(entityClass, "entityClass is required");
        return this.toEntity(entityClass, entity.getDocuments());
    }

    @Override
    public <T> T toEntity(T entityInstance, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(entityInstance, "entityInstance is required");
        ClassRepresentation representation = this.getClassRepresentations().get(entityInstance.getClass());
        return this.convertEntity(entity.getDocuments(), representation, entityInstance);
    }

    protected <T> T toEntity(Class<T> entityClass, List<Document> documents) {
        ClassRepresentation representation = this.getClassRepresentations().get(entityClass);
        Object instance = this.getReflections().newInstance(representation.getConstructor());
        return (T)this.convertEntity(documents, representation, instance);
    }

    @Override
    public <T> T toEntity(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        ClassRepresentation representation = this.getClassRepresentations().findByName(entity.getName());
        Object instance = this.getReflections().newInstance(representation.getConstructor());
        return (T)this.convertEntity(entity.getDocuments(), representation, instance);
    }

    private <T> T convertEntity(List<Document> documents, ClassRepresentation representation, T instance) {
        Map fieldsGroupByName = representation.getFieldsGroupByName();
        List names = documents.stream().map(Document::getName).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            FieldType type = ((FieldRepresentation)fieldsGroupByName.get(k)).getType();
            return FieldType.EMBEDDED.equals((Object)type) || FieldType.SUBENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, documents, fieldsGroupByName));
        return instance;
    }

    protected <T> Consumer<String> feedObject(T instance, List<Document> documents, Map<String, FieldRepresentation> fieldsGroupByName) {
        return k -> {
            Optional<Document> document = documents.stream().filter(c -> c.getName().equals(k)).findFirst();
            FieldRepresentation field = (FieldRepresentation)fieldsGroupByName.get(k);
            DocumentFieldConverter fieldConverter = this.converterFactory.get(field);
            fieldConverter.convert(instance, documents, document, field, this);
        };
    }

    private DocumentFieldValue to(FieldRepresentation field, Object entityInstance) {
        Object value = this.getReflections().getValue(entityInstance, field.getNativeField());
        return DefaultDocumentFieldValue.of(value, field);
    }
}

