/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.configuration.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.configuration.Configurable;
import org.jnosql.artemis.configuration.ConfigurableReader;
import org.jnosql.artemis.configuration.ConfigurationException;
import org.jnosql.artemis.configuration.xml.ConfigurablesXML;

@Named(value="xml")
@ApplicationScoped
class ConfigurableReaderXML
implements ConfigurableReader {
    private static final JAXBContext JAXB_CONTEX;
    private static final ThreadLocal<Unmarshaller> UNMARSHALLER;
    private static final Logger LOGGER;
    private final Map<String, List<Configurable>> cache = new ConcurrentHashMap<String, List<Configurable>>();

    ConfigurableReaderXML() {
    }

    @Override
    public List<Configurable> read(Supplier<InputStream> stream, ConfigurationUnit annotation) {
        List<Configurable> configurations = this.cache.get(annotation.fileName());
        if (Objects.nonNull(configurations)) {
            LOGGER.fine("Loading the configuration file from the cache file: " + annotation.fileName());
            return configurations;
        }
        try {
            Unmarshaller unmarshaller = UNMARSHALLER.get();
            ConfigurablesXML configurablesXML = (ConfigurablesXML)unmarshaller.unmarshal(stream.get());
            ArrayList<Configurable> configurables = new ArrayList<Configurable>(Optional.ofNullable(configurablesXML.getConfigurations()).orElse(Collections.emptyList()));
            this.cache.put(annotation.fileName(), configurables);
            return configurables;
        }
        catch (JAXBException e) {
            throw new ConfigurationException("Error to read XML file:" + annotation.fileName(), e);
        }
    }

    static {
        LOGGER = Logger.getLogger(ConfigurableReaderXML.class.getName());
        try {
            JAXB_CONTEX = JAXBContext.newInstance((Class[])new Class[]{ConfigurablesXML.class});
            UNMARSHALLER = ThreadLocal.withInitial(() -> {
                try {
                    return JAXB_CONTEX.createUnmarshaller();
                }
                catch (JAXBException e) {
                    throw new ConfigurationException("Error to load xml Unmarshaller context", e);
                }
            });
        }
        catch (JAXBException e) {
            throw new ConfigurationException("Error to load xml context", e);
        }
    }
}

