/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.configuration;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationReader;
import org.jnosql.artemis.ConfigurationSettingsUnit;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.configuration.Configurable;
import org.jnosql.artemis.configuration.ConfigurableReader;
import org.jnosql.artemis.configuration.ConfigurationException;
import org.jnosql.artemis.configuration.DefaultConfigurationSettingsUnit;
import org.jnosql.artemis.configuration.NamedLiteral;
import org.jnosql.artemis.reflection.ConstructorException;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.artemis.util.StringUtils;
import org.jnosql.diana.api.Settings;

@ApplicationScoped
class DefaultConfigurationReader
implements ConfigurationReader {
    private static final String META_INF = "META-INF/";
    private static final String WEB_INF = "WEB-INF/";
    private static final Logger LOGGER = Logger.getLogger(DefaultConfigurationReader.class.getName());
    @Inject
    private Reflections reflections;
    @Inject
    @Any
    private Instance<ConfigurableReader> readers;

    DefaultConfigurationReader() {
    }

    public <T> ConfigurationSettingsUnit read(ConfigurationUnit annotation, Class<T> configurationClass) {
        Objects.requireNonNull(annotation, "annotation is required");
        Objects.requireNonNull(configurationClass, "configurationClass is required");
        List<Configurable> configurations = this.getConfigurations(annotation);
        Configurable configuration = this.getConfiguration(annotation, configurations);
        String name = configuration.getName();
        String description = configuration.getDescription();
        HashMap settings = new HashMap(Optional.ofNullable(configuration.getSettings()).orElse(Collections.emptyMap()));
        Class<?> provider = this.getProvider(configurationClass, configuration);
        return new DefaultConfigurationSettingsUnit(name, description, provider, Settings.of(settings));
    }

    public <T> ConfigurationSettingsUnit read(ConfigurationUnit annotation) {
        Objects.requireNonNull(annotation, "annotation is required");
        List<Configurable> configurations = this.getConfigurations(annotation);
        Configurable configuration = this.getConfiguration(annotation, configurations);
        String name = configuration.getName();
        String description = configuration.getDescription();
        HashMap settings = new HashMap(Optional.ofNullable(configuration.getSettings()).orElse(Collections.emptyMap()));
        return new DefaultConfigurationSettingsUnit(name, description, null, Settings.of(settings));
    }

    private List<Configurable> getConfigurations(ConfigurationUnit annotation) {
        Supplier<InputStream> stream = this.readStream(annotation);
        String extension = this.getExtension(annotation);
        Instance select = this.readers.select(new Annotation[]{new NamedLiteral(extension)});
        if (select.isUnsatisfied()) {
            throw new ConfigurationException(String.format("The extension %s is not supported", extension));
        }
        return ((ConfigurableReader)select.get()).read(stream, annotation);
    }

    private String getExtension(ConfigurationUnit annotation) {
        String[] fileName = annotation.fileName().split("\\.");
        if (fileName.length != 2) {
            throw new ConfigurationException("The cofinguration file is invalid: " + annotation.fileName());
        }
        return fileName[1];
    }

    private <T> Class<?> getProvider(Class<T> configurationClass, Configurable configuration) {
        if (StringUtils.isBlank((CharSequence)configuration.getProvider())) {
            return null;
        }
        try {
            Class<?> provider = Class.forName(configuration.getProvider());
            if (!configurationClass.isAssignableFrom(provider)) {
                throw new ConfigurationException(String.format("The class %s does not match with %s", provider.toString(), configurationClass));
            }
            this.reflections.makeAccessible(provider);
            return provider;
        }
        catch (ClassNotFoundException | ConstructorException e) {
            throw new ConfigurationException("An error to load the provider class: " + configuration.getProvider(), e);
        }
    }

    private Configurable getConfiguration(ConfigurationUnit annotation, List<Configurable> configurations) {
        String name = annotation.name();
        String fileName = annotation.fileName();
        if (StringUtils.isBlank((CharSequence)name)) {
            if (configurations.size() > 1) {
                throw new ConfigurationException(String.format("An ambitious error happened once the file %s has more than one configuration unit.", name));
            }
            return (Configurable)configurations.stream().findFirst().orElseThrow(() -> new ConfigurationException("There is not unit in the file: " + fileName));
        }
        return configurations.stream().filter(c -> name.equals(c.getName())).findFirst().orElseThrow(() -> new ConfigurationException(String.format("The unit %s does not find in the file %s", name, fileName)));
    }

    private Supplier<InputStream> readStream(ConfigurationUnit annotation) {
        return () -> {
            String metaInfFile = META_INF + annotation.fileName();
            LOGGER.fine("Reading the configuration file: " + metaInfFile);
            InputStream stream = DefaultConfigurationReader.class.getClassLoader().getResourceAsStream(metaInfFile);
            if (Objects.isNull(stream)) {
                String webInfFile = WEB_INF + annotation.fileName();
                LOGGER.fine("Reading the configuration file: " + webInfFile);
                stream = DefaultConfigurationReader.class.getClassLoader().getResourceAsStream(webInfFile);
            }
            return Optional.ofNullable(stream).orElseThrow(() -> new ConfigurationException("The File does not found at: " + annotation.fileName()));
        };
    }
}

