/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.app.Application;
import com.jme3.input.AWTKeyInput;
import com.jme3.input.AWTMouseInput;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.AWTComponentRenderer;
import com.jme3.system.AWTContext;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.SafeArrayList;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AWTFrameProcessor
implements SceneProcessor,
PropertyChangeListener {
    private Application application = null;
    protected PropertyChangeListener widthListener;
    protected PropertyChangeListener heightListener;
    protected PropertyChangeListener rationListener;
    private final AtomicInteger reshapeNeeded;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private AWTComponentRenderer frameTransfer;
    private TransferMode transferMode = TransferMode.ALWAYS;
    protected volatile Component destination;
    private volatile boolean main = true;
    private int askWidth = 1;
    private int askHeight = 1;
    private boolean askFixAspect;
    private boolean enabled;

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return this.frameTransfer != null;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (!this.isEnabled()) {
            return;
        }
        AWTComponentRenderer frameTransfer = this.getFrameTransfer();
        if (frameTransfer != null) {
            frameTransfer.copyFrameBufferToImage(this.getRenderManager());
        }
        if (this.hasDestination() && this.reshapeNeeded.get() > 0 && this.reshapeNeeded.decrementAndGet() >= 0) {
            if (frameTransfer != null) {
                frameTransfer.dispose();
            }
            this.setFrameTransfer(this.reshapeInThread(this.askWidth, this.askHeight, this.askFixAspect));
        }
    }

    public void cleanup() {
        AWTComponentRenderer frameTransfer = this.getFrameTransfer();
        if (frameTransfer != null) {
            frameTransfer.dispose();
            this.setFrameTransfer(null);
        }
    }

    public void setProfiler(AppProfiler profiler) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println("Property changed: " + evt.getPropertyName() + " " + evt.getOldValue() + " -> " + evt.getNewValue());
    }

    public AWTFrameProcessor() {
        this.reshapeNeeded = new AtomicInteger(2);
    }

    protected void notifyChangedRatio(Boolean newValue) {
        this.notifyComponentResized(this.destination.getWidth(), this.destination.getHeight(), newValue);
    }

    protected void notifyChangedHeight(Number newValue) {
        this.notifyComponentResized(this.destination.getWidth(), newValue.intValue(), this.isPreserveRatio());
    }

    protected void notifyChangedWidth(Number newValue) {
        this.notifyComponentResized(newValue.intValue(), this.destination.getHeight(), this.isPreserveRatio());
    }

    protected Application getApplication() {
        return this.application;
    }

    protected void setApplication(Application application) {
        this.application = application;
    }

    protected Component getDestination() {
        return this.destination;
    }

    protected void setDestination(Component destination) {
        this.destination = destination;
    }

    protected boolean hasDestination() {
        return this.destination != null;
    }

    protected boolean hasApplication() {
        return this.application != null;
    }

    protected AWTComponentRenderer getFrameTransfer() {
        return this.frameTransfer;
    }

    protected void setFrameTransfer(AWTComponentRenderer frameTransfer) {
        this.frameTransfer = frameTransfer;
    }

    protected ViewPort getViewPort() {
        return this.viewPort;
    }

    protected RenderManager getRenderManager() {
        return this.renderManager;
    }

    public boolean isMain() {
        return this.main;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void notifyComponentResized(int newWidth, int newHeight, boolean fixAspect) {
        newWidth = Math.max(newWidth, 1);
        newHeight = Math.max(newHeight, 1);
        if (this.askWidth == newWidth && this.askWidth == newHeight && this.askFixAspect == fixAspect) {
            return;
        }
        this.askWidth = newWidth;
        this.askHeight = newHeight;
        this.askFixAspect = fixAspect;
        this.reshapeNeeded.set(2);
    }

    public void reshape() {
        this.reshapeNeeded.set(2);
    }

    protected boolean isPreserveRatio() {
        return false;
    }

    protected int getDestinationWidth() {
        return this.getDestination().getWidth();
    }

    protected int getDestinationHeight() {
        return this.getDestination().getHeight();
    }

    public void bind(Component destination, Application application) {
        RenderManager renderManager = application.getRenderManager();
        if (renderManager == null) {
            throw new RuntimeException("No render manager available from the application.");
        }
        List postViews = renderManager.getPostViews();
        if (postViews.isEmpty()) {
            throw new RuntimeException("the list of a post view is empty.");
        }
        this.bind(destination, application, (ViewPort)postViews.get(postViews.size() - 1), true);
    }

    public void bind(Component destination, Application application, ViewPort viewPort) {
        this.bind(destination, application, viewPort, true);
    }

    public void bind(final Component destination, final Application application, ViewPort viewPort, boolean main) {
        if (this.hasApplication()) {
            throw new RuntimeException("This process is already bonded.");
        }
        this.setApplication(application);
        this.setEnabled(true);
        this.main = main;
        this.viewPort = viewPort;
        this.viewPort.addProcessor((SceneProcessor)this);
        if (EventQueue.isDispatchThread()) {
            this.bindDestination(application, destination);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTFrameProcessor.this.bindDestination(application, destination);
                }
            });
        }
    }

    public void unbind() {
        if (this.viewPort != null) {
            this.viewPort.removeProcessor((SceneProcessor)this);
            this.viewPort = null;
        }
        if (EventQueue.isDispatchThread()) {
            this.unbindDestination();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTFrameProcessor.this.unbindDestination();
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bindDestination(Application application, Component destination) {
        if (!EventQueue.isDispatchThread()) {
            throw new RuntimeException("bind has to be done from the Event Dispatching thread.");
        }
        if (!this.isMain()) return;
        if (application.getContext() == null) throw new IllegalArgumentException("Underlying application has to use a valid AWTContext (context is null)");
        if (!(application.getContext() instanceof AWTContext)) throw new IllegalArgumentException("Underlying application has to use AWTContext (actually using " + application.getContext().getClass().getSimpleName() + ")");
        AWTContext context = (AWTContext)application.getContext();
        AWTMouseInput mouseInput = context.getMouseInput();
        mouseInput.bind(destination);
        AWTKeyInput keyInput = context.getKeyInput();
        keyInput.bind(destination);
        this.setDestination(destination);
        this.bindListeners();
        this.notifyComponentResized(this.getDestinationWidth(), this.getDestinationHeight(), this.isPreserveRatio());
    }

    protected void unbindDestination() {
        if (!EventQueue.isDispatchThread()) {
            throw new RuntimeException("unbind has to be done from the Event Dispatching thread.");
        }
        if (this.hasApplication() && this.isMain()) {
            AWTContext context = (AWTContext)this.getApplication().getContext();
            AWTMouseInput mouseInput = context.getMouseInput();
            mouseInput.unbind();
            AWTKeyInput keyInput = context.getKeyInput();
            keyInput.unbind();
        }
        this.setApplication(null);
        if (this.hasDestination()) {
            this.unbindListeners();
            this.setDestination(null);
        }
    }

    protected void bindListeners() {
        Component destination = this.getDestination();
        destination.addPropertyChangeListener(this);
        destination.addPropertyChangeListener(this);
    }

    protected void unbindListeners() {
        Component destination = this.getDestination();
        destination.removePropertyChangeListener(this);
        destination.removePropertyChangeListener(this);
    }

    protected AWTComponentRenderer reshapeInThread(int width, int height, boolean fixAspect) {
        this.reshapeCurrentViewPort(width, height);
        ViewPort viewPort = this.getViewPort();
        RenderManager renderManager = this.getRenderManager();
        FrameBuffer frameBuffer = viewPort.getOutputFrameBuffer();
        AWTComponentRenderer frameTransfer = this.createFrameTransfer(frameBuffer, width, height);
        frameTransfer.init(renderManager.getRenderer(), this.isMain());
        if (this.isMain()) {
            AWTContext context = (AWTContext)this.getApplication().getContext();
            context.setHeight(height);
            context.setWidth(width);
        }
        return frameTransfer;
    }

    protected AWTComponentRenderer createFrameTransfer(FrameBuffer frameBuffer, int width, int height) {
        return new AWTComponentRenderer(this.getDestination(), this.getTransferMode(), this.isMain() ? null : frameBuffer, width, height);
    }

    protected void reshapeCurrentViewPort(int width, int height) {
        ViewPort viewPort = this.getViewPort();
        Camera camera = viewPort.getCamera();
        int cameraAngle = this.getCameraAngle();
        float aspect = (float)camera.getWidth() / (float)camera.getHeight();
        if (this.isMain()) {
            this.getRenderManager().notifyReshape(width, height);
            camera.setFrustumPerspective((float)cameraAngle, aspect, 1.0f, 10000.0f);
            return;
        }
        camera.resize(width, height, true);
        camera.setFrustumPerspective((float)cameraAngle, aspect, 1.0f, 10000.0f);
        SafeArrayList processors = viewPort.getProcessors();
        boolean found = false;
        Iterator iter = processors.iterator();
        while (!found && iter.hasNext()) {
            if (iter.next() instanceof AWTFrameProcessor) continue;
            found = true;
        }
        if (found) {
            FrameBuffer frameBuffer = new FrameBuffer(width, height, 1);
            frameBuffer.setDepthBuffer(Image.Format.Depth);
            frameBuffer.setColorBuffer(Image.Format.RGBA8);
            frameBuffer.setSrgb(true);
            viewPort.setOutputFrameBuffer(frameBuffer);
        }
        for (SceneProcessor sceneProcessor : processors) {
            if (!sceneProcessor.isInitialized()) {
                sceneProcessor.initialize(this.renderManager, viewPort);
                continue;
            }
            sceneProcessor.reshape(viewPort, width, height);
        }
    }

    protected int getCameraAngle() {
        String angle = System.getProperty("awt.frame.transfer.camera.angle", "45");
        return Integer.parseInt(angle);
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
    }

    public static enum TransferMode {
        ALWAYS,
        ON_CHANGES;

    }
}

