/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.wrapper;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jmolecules.annotation.processor.aptk.tools.AnnotationValueUtils;
import org.jmolecules.annotation.processor.aptk.tools.TypeMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.AnnotationMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.VariableElementWrapper;

public class AnnotationValueWrapper {
    final AnnotationValue annotationValue;

    private AnnotationValueWrapper(AnnotationValue annotationValue) {
        this.annotationValue = annotationValue;
    }

    public AnnotationValue unwrap() {
        return this.annotationValue;
    }

    public boolean isInteger() {
        return AnnotationValueUtils.isInteger(this.annotationValue);
    }

    public boolean isLong() {
        return AnnotationValueUtils.isLong(this.annotationValue);
    }

    public boolean isBoolean() {
        return AnnotationValueUtils.isBoolean(this.annotationValue);
    }

    public boolean isFloat() {
        return AnnotationValueUtils.isFloat(this.annotationValue);
    }

    public boolean isDouble() {
        return AnnotationValueUtils.isDouble(this.annotationValue);
    }

    public boolean isString() {
        return AnnotationValueUtils.isString(this.annotationValue);
    }

    public boolean isChar() {
        return AnnotationValueUtils.isChar(this.annotationValue);
    }

    public boolean isEnum() {
        return AnnotationValueUtils.isEnum(this.annotationValue);
    }

    public boolean isClass() {
        return AnnotationValueUtils.isClass(this.annotationValue);
    }

    public boolean isArray() {
        return AnnotationValueUtils.isArray(this.annotationValue);
    }

    public boolean isAnnotation() {
        return AnnotationValueUtils.isAnnotation(this.annotationValue);
    }

    public Long getLongValue() {
        return AnnotationValueUtils.getLongValue(this.annotationValue);
    }

    public Integer getIntegerValue() {
        return AnnotationValueUtils.getIntegerValue(this.annotationValue);
    }

    public Boolean getBooleanValue() {
        return AnnotationValueUtils.getBooleanValue(this.annotationValue);
    }

    public Float getFloatValue() {
        return AnnotationValueUtils.getFloatValue(this.annotationValue);
    }

    public Double getDoubleValue() {
        return AnnotationValueUtils.getDoubleValue(this.annotationValue);
    }

    public String getStringValue() {
        return AnnotationValueUtils.getStringValue(this.annotationValue);
    }

    public Character getCharValue() {
        return AnnotationValueUtils.getCharValue(this.annotationValue);
    }

    public TypeMirrorWrapper getClassValue() {
        TypeMirror typeMirror = AnnotationValueUtils.getTypeMirrorValue(this.annotationValue);
        return typeMirror != null ? TypeMirrorWrapper.wrap(typeMirror) : null;
    }

    public VariableElementWrapper getEnumValue() {
        VariableElement result = AnnotationValueUtils.getEnumValue(this.annotationValue);
        return result != null ? VariableElementWrapper.wrap(result) : null;
    }

    public <T extends Enum<T>> T getEnumValue(Class<T> enumType) {
        return AnnotationValueUtils.getEnumValue(enumType, this.annotationValue);
    }

    public AnnotationMirrorWrapper getAnnotationValue() {
        AnnotationMirror annotationMirror = AnnotationValueUtils.getAnnotationValue(this.annotationValue);
        return annotationMirror != null ? AnnotationMirrorWrapper.wrap(annotationMirror) : null;
    }

    public List<AnnotationValueWrapper> getArrayValue() {
        List<? extends AnnotationValue> annotationMirrors = AnnotationValueUtils.getArrayValue(this.annotationValue);
        return annotationMirrors != null ? annotationMirrors.stream().map(AnnotationValueWrapper::wrap).collect(Collectors.toList()) : null;
    }

    public static AnnotationValueWrapper wrap(AnnotationValue annotationValue) {
        return new AnnotationValueWrapper(annotationValue);
    }
}

