/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.matcher.impl;

import javax.lang.model.element.Element;
import org.jmolecules.annotation.processor.aptk.tools.TypeUtils;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericType;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericTypeParameter;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericTypeWildcard;
import org.jmolecules.annotation.processor.aptk.tools.matcher.CriteriaMatcher;

public class ByGenericTypeMatcher
implements CriteriaMatcher<Element, GenericType> {
    @Override
    public boolean checkForMatchingCharacteristic(Element element, GenericType toCheckFor) {
        return element != null && toCheckFor != null && TypeUtils.Generics.genericTypeEquals(element.asType(), toCheckFor);
    }

    @Override
    public String getStringRepresentationOfPassedCharacteristic(GenericType toGetStringRepresentationFor) {
        if (toGetStringRepresentationFor == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.createStringRepresentationRecursively(stringBuilder, toGetStringRepresentationFor);
        return stringBuilder.toString();
    }

    private void createStringRepresentationRecursively(StringBuilder stringBuilder, GenericType toGetStringRepresentationFor) {
        stringBuilder.append(TypeUtils.getTypes().erasure(toGetStringRepresentationFor.getRawType()).toString());
        if (toGetStringRepresentationFor.getTypeParameters().length > 0) {
            stringBuilder.append("<");
            boolean first = true;
            block4: for (int i = 0; i < toGetStringRepresentationFor.getTypeParameters().length; ++i) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                GenericTypeParameter currentGenericTypeParameter = toGetStringRepresentationFor.getTypeParameters()[i];
                switch (currentGenericTypeParameter.getType()) {
                    case WILDCARD: {
                        GenericTypeWildcard wildcard = (GenericTypeWildcard)currentGenericTypeParameter;
                        if (wildcard.isPureWildcard()) {
                            stringBuilder.append("?");
                            continue block4;
                        }
                        if (wildcard.hasExtendsBound()) {
                            stringBuilder.append("? extends ");
                            this.createStringRepresentationRecursively(stringBuilder, wildcard.getExtendsBound());
                            continue block4;
                        }
                        if (!wildcard.hasSuperBound()) continue block4;
                        stringBuilder.append("? super ");
                        this.createStringRepresentationRecursively(stringBuilder, wildcard.getSuperBound());
                        continue block4;
                    }
                    case GENERIC_TYPE: {
                        this.createStringRepresentationRecursively(stringBuilder, (GenericType)currentGenericTypeParameter);
                        continue block4;
                    }
                }
            }
            stringBuilder.append(">");
        }
    }
}

