/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.fluentfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import org.jmolecules.annotation.processor.aptk.tools.command.Command;
import org.jmolecules.annotation.processor.aptk.tools.command.CommandWithReturnType;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.ExclusiveCriteriaCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.ExclusiveCriteriaElementBasedCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.ImplicitCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.ImplicitElementBasedCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.InclusiveCharacteristicElementBasedCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.InclusiveCriteriaCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.IsCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.IsElementBasedCoreMatcher;
import org.jmolecules.annotation.processor.aptk.tools.filter.ExclusiveCriteriaElementFilter;
import org.jmolecules.annotation.processor.aptk.tools.filter.InclusiveCriteriaElementFilter;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.TransitionFilters;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.impl.ElementBasedTransitionFilter;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.impl.TransitionFilter;
import org.jmolecules.annotation.processor.aptk.tools.matcher.CriteriaMatcher;
import org.jmolecules.annotation.processor.aptk.tools.validator.ExclusiveCriteriaElementValidator;
import org.jmolecules.annotation.processor.aptk.tools.validator.InclusiveCriteriaElementValidator;

public class FluentElementFilter<ELEMENT extends Element> {
    private final List<ELEMENT> elements;

    private FluentElementFilter(List<ELEMENT> elements) {
        this.elements = elements;
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<TARGET_ELEMENT> applyFilter(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
        return new FluentElementFilter<ELEMENT>(coreMatcher.getFilter().filter(this.elements));
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<ELEMENT> applyInvertedFilter(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
        return new FluentElementFilter<ELEMENT>(coreMatcher.getFilter().filter(this.elements, true));
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<TARGET_ELEMENT> applyFilter(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
        return new FluentElementFilter<Element>(coreMatcher.getFilter().filter(this.elements));
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<ELEMENT> applyInvertedFilter(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
        return new FluentElementFilter<Element>(coreMatcher.getFilter().filter(this.elements, true));
    }

    public FluentElementFilter<ELEMENT> applyFilter(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
        return new FluentElementFilter<ELEMENT>(coreMatcher.getFilter().filter(this.elements));
    }

    public FluentElementFilter<ELEMENT> applyInvertedFilter(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
        return new FluentElementFilter<ELEMENT>(coreMatcher.getFilter().filter(this.elements, true));
    }

    public FluentElementFilter<ELEMENT> applyFilter(ImplicitElementBasedCoreMatcher coreMatcher) {
        return new FluentElementFilter<Element>(coreMatcher.getFilter().filter(this.elements));
    }

    public FluentElementFilter<ELEMENT> applyInvertedFilter(ImplicitElementBasedCoreMatcher coreMatcher) {
        return new FluentElementFilter<Element>(coreMatcher.getFilter().filter(this.elements, true));
    }

    public <CRITERIA> InclusiveCriteriaFluentFilter<ELEMENT, CRITERIA> applyFilter(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new InclusiveCriteriaFluentFilter(coreMatcher.getFilter(), false);
    }

    public <CRITERIA> InclusiveCriteriaFluentFilter<ELEMENT, CRITERIA> applyInvertedFilter(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new InclusiveCriteriaFluentFilter(coreMatcher.getFilter(), true);
    }

    public <CRITERIA> InclusiveCriteriaFluentFilter<Element, CRITERIA> applyFilter(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new InclusiveCriteriaFluentFilter(coreMatcher.getFilter(), false);
    }

    public <CRITERIA> InclusiveCriteriaFluentFilter<Element, CRITERIA> applyInvertedFilter(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new InclusiveCriteriaFluentFilter(coreMatcher.getFilter(), true);
    }

    public <CHARACTERISTIC> ExclusiveCharacteristicFluentFilter<ELEMENT, CHARACTERISTIC> applyFilter(ExclusiveCriteriaCoreMatcher<ELEMENT, CHARACTERISTIC> coreMatcher) {
        return new ExclusiveCharacteristicFluentFilter(coreMatcher.getFilter(), false);
    }

    public <CHARACTERISTIC> ExclusiveCharacteristicFluentFilter<ELEMENT, CHARACTERISTIC> applyInvertedFilter(ExclusiveCriteriaCoreMatcher<ELEMENT, CHARACTERISTIC> coreMatcher) {
        return new ExclusiveCharacteristicFluentFilter(coreMatcher.getFilter(), true);
    }

    public <CHARACTERISTIC> ExclusiveCharacteristicFluentFilter<Element, CHARACTERISTIC> applyFilter(ExclusiveCriteriaElementBasedCoreMatcher<CHARACTERISTIC> coreMatcher) {
        return new ExclusiveCharacteristicFluentFilter(coreMatcher.getFilter(), false);
    }

    public <CHARACTERISTIC> ExclusiveCharacteristicFluentFilter<Element, CHARACTERISTIC> applyInvertedFilter(ExclusiveCriteriaElementBasedCoreMatcher<CHARACTERISTIC> coreMatcher) {
        return new ExclusiveCharacteristicFluentFilter(coreMatcher.getFilter(), true);
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<TARGET_ELEMENT> applyTransitionFilter(TransitionFilter<ELEMENT, TARGET_ELEMENT> transitionFilter) {
        return new FluentElementFilter<TARGET_ELEMENT>(transitionFilter.transition(this.elements));
    }

    public <TARGET_ELEMENT extends Element> FluentElementFilter<TARGET_ELEMENT> applyTransitionFilter(ElementBasedTransitionFilter<TARGET_ELEMENT> transitionFilter) {
        return new FluentElementFilter<TARGET_ELEMENT>(transitionFilter.transition(this.elements));
    }

    public FluentElementFilter<ELEMENT> removeDuplicates() {
        return new FluentElementFilter<Element>(TransitionFilters.REMOVE_DUPLICATES_ELEMENTS.transition(this.elements));
    }

    public void executeCommand(Command<ELEMENT> command) {
        if (command != null) {
            for (Element element : this.elements) {
                command.execute(element);
            }
        }
    }

    public <RETURN_TYPE> List<RETURN_TYPE> executeCommand(CommandWithReturnType<ELEMENT, RETURN_TYPE> command) {
        ArrayList<RETURN_TYPE> resultList = new ArrayList<RETURN_TYPE>();
        if (command != null) {
            for (Element element : this.elements) {
                resultList.add(command.execute(element));
            }
        }
        return resultList;
    }

    public List<ELEMENT> getResult() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public boolean hasSingleElement() {
        return this.elements != null && this.elements.size() == 1;
    }

    public boolean hasMultipleElements() {
        return this.elements != null && this.elements.size() > 1;
    }

    public boolean hasSize(int size) {
        return this.elements != null && this.elements.size() == size;
    }

    public int getResultSize() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public static <E extends Element> FluentElementFilter<E> createFluentElementFilter(List<E> elements) {
        return new FluentElementFilter<E>(elements);
    }

    public static <E extends Element> FluentElementFilter<E> createFluentElementFilter(E ... elements) {
        return new FluentElementFilter<E>(new ArrayList<E>(elements != null ? Arrays.asList(elements) : Collections.EMPTY_LIST));
    }

    public class InclusiveCriteriaFluentFilter<FILTER_ELEMENT extends Element, CHARACTERISTIC> {
        private final boolean inverted;
        private final InclusiveCriteriaElementFilter<FILTER_ELEMENT, CHARACTERISTIC, InclusiveCriteriaElementValidator<FILTER_ELEMENT, CHARACTERISTIC, CriteriaMatcher<FILTER_ELEMENT, CHARACTERISTIC>>> filter;

        private InclusiveCriteriaFluentFilter(InclusiveCriteriaElementFilter<FILTER_ELEMENT, CHARACTERISTIC, InclusiveCriteriaElementValidator<FILTER_ELEMENT, CHARACTERISTIC, CriteriaMatcher<FILTER_ELEMENT, CHARACTERISTIC>>> filter, boolean inverted) {
            this.filter = filter;
            this.inverted = inverted;
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByOneOf(CHARACTERISTIC ... criteria) {
            return new FluentElementFilter(this.filter.filterByOneOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByNoneOf(CHARACTERISTIC ... criteria) {
            return new FluentElementFilter(this.filter.filterByNoneOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByAtLeastOneOf(CHARACTERISTIC ... criteria) {
            return new FluentElementFilter(this.filter.filterByAtLeastOneOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByAllOf(CHARACTERISTIC ... criteria) {
            return new FluentElementFilter(this.filter.filterByAllOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }
    }

    public class ExclusiveCharacteristicFluentFilter<FILTER_ELEMENT extends Element, CRITERIA> {
        private final boolean inverted;
        private final ExclusiveCriteriaElementFilter<FILTER_ELEMENT, CRITERIA, ExclusiveCriteriaElementValidator<FILTER_ELEMENT, CRITERIA, CriteriaMatcher<FILTER_ELEMENT, CRITERIA>>> filter;

        private ExclusiveCharacteristicFluentFilter(ExclusiveCriteriaElementFilter<FILTER_ELEMENT, CRITERIA, ExclusiveCriteriaElementValidator<FILTER_ELEMENT, CRITERIA, CriteriaMatcher<FILTER_ELEMENT, CRITERIA>>> filter, boolean inverted) {
            this.filter = filter;
            this.inverted = inverted;
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByOneOf(CRITERIA ... criteria) {
            return new FluentElementFilter(this.filter.filterByOneOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }

        @SafeVarargs
        public final FluentElementFilter<ELEMENT> filterByNoneOf(CRITERIA ... criteria) {
            return new FluentElementFilter(this.filter.filterByNoneOf(FluentElementFilter.this.elements, this.inverted, criteria));
        }
    }
}

