/*
 * Decompiled with CFR 0.152.
 */
package org.jipijapa.eclipselink;

import java.util.Map;
import org.eclipse.persistence.Version;
import org.jboss.logging.Logger;
import org.jipijapa.eclipselink.JBossAS7ServerPlatform;
import org.jipijapa.eclipselink.JBossArchiveFactoryImpl;
import org.jipijapa.eclipselink.JBossLogger;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.Platform;

public class EclipseLinkPersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private final Logger logger = Logger.getLogger(EclipseLinkPersistenceProviderAdaptor.class);
    public static final String ECLIPSELINK_TARGET_SERVER = "eclipselink.target-server";
    public static final String ECLIPSELINK_ARCHIVE_FACTORY = "eclipselink.archive.factory";
    public static final String ECLIPSELINK_LOGGING_LOGGER = "eclipselink.logging.logger";
    private final boolean hasJTABug;

    public EclipseLinkPersistenceProviderAdaptor() {
        int rev;
        int minor;
        int major;
        this.logger.trace((Object)"EclipseLink integration activated");
        try {
            String[] eclipseLinkVersion = Version.getVersion().split("\\.");
            major = Integer.parseInt(eclipseLinkVersion[0]);
            minor = Integer.parseInt(eclipseLinkVersion[1]);
            rev = Integer.parseInt(eclipseLinkVersion[2]);
        }
        catch (NumberFormatException ex) {
            this.logger.warn((Object)("Could not parse EclipseLink version string " + ex + ", using default configuration"));
            major = -1;
            minor = -1;
            rev = -1;
        }
        if (major < 2) {
            this.logger.warn((Object)("EclipseLink 1.x is not tested. You are running version " + major + '.' + minor + '.' + rev + ". "));
            this.hasJTABug = true;
        } else if (major == 2 && minor == 3 && rev <= 2 || major == 2 && minor < 3) {
            this.logger.info((Object)"Enabling workaronud for EclipseLink bug 365704 for EclipseLink 2.3.2 and older");
            this.hasJTABug = true;
        } else {
            this.hasJTABug = false;
        }
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        if (!properties.containsKey(ECLIPSELINK_TARGET_SERVER)) {
            properties.put(ECLIPSELINK_TARGET_SERVER, JBossAS7ServerPlatform.class.getName());
            properties.put(ECLIPSELINK_ARCHIVE_FACTORY, JBossArchiveFactoryImpl.class.getName());
            properties.put(ECLIPSELINK_LOGGING_LOGGER, JBossLogger.class.getName());
        }
        this.logger.trace((Object)("Property eclipselink.target-server set to " + properties.get(ECLIPSELINK_TARGET_SERVER)));
        this.logger.trace((Object)("Property eclipselink.archive.factory set to " + properties.get(ECLIPSELINK_ARCHIVE_FACTORY)));
        this.logger.trace((Object)("Property eclipselink.logging.logger set to " + properties.get(ECLIPSELINK_LOGGING_LOGGER)));
    }

    public void injectJtaManager(JtaManager jtaManager) {
    }

    public void injectPlatform(Platform platform) {
    }

    public void addProviderDependencies(PersistenceUnitMetadata pu) {
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
    }

    public ManagementAdaptor getManagementAdaptor() {
        return null;
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        return false;
    }

    public void cleanup(PersistenceUnitMetadata pu) {
    }
}

