/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.BasicSymbolicInterpreter;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jinq.orm.stream.JinqStream;

class MethodChecker
implements PathAnalysisMethodChecker {
    private final Set<Class<?>> safeMethodAnnotations;
    private final Set<MethodSignature> safeMethods;
    private final Set<MethodSignature> safeStaticMethods;
    private final boolean isObjectEqualsSafe;
    private final boolean isAllEqualsSafe;
    private final boolean isCollectionContainsSafe;
    public static final MethodSignature objectEquals = new MethodSignature("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature guavaObjectsEqual = new MethodSignature("com/google/common/base/Objects", "equal", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
    public static final MethodSignature objectsEquals = new MethodSignature("java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
    public static final MethodSignature jpqlLike;
    public static final MethodSignature jpqlIsIn;
    public static final MethodSignature jpqlIsInList;
    public static final MethodSignature jpqlListContains;
    public static final MethodSignature mathSqrt;
    public static final MethodSignature mathAbsDouble;
    public static final MethodSignature mathAbsInt;
    public static final MethodSignature mathAbsLong;
    public static final MethodSignature bigDecimalAbs;
    public static final MethodSignature bigIntegerAbs;
    public static final MethodSignature bigDecimalNegate;
    public static final MethodSignature bigIntegerNegate;
    public static final MethodSignature stringToUpper;
    public static final MethodSignature stringToLower;
    public static final MethodSignature stringValueOfObject;
    public static final MethodSignature stringTrim;
    public static final MethodSignature stringLength;
    public static final MethodSignature stringSubstring;
    public static final MethodSignature stringIndexOf;
    public static final MethodSignature stringContains;
    public static final MethodSignature stringStartsWith;
    static final Set<MethodSignature> jpqlFunctionMethods;
    static final Set<MethodSignature> jpqlFunctionStaticMethods;
    public static final MethodSignature streamSumInt;
    public static final MethodSignature streamSumDouble;
    public static final MethodSignature streamSumLong;
    public static final MethodSignature streamSumBigDecimal;
    public static final MethodSignature streamSumBigInteger;
    public static final MethodSignature streamMax;
    public static final MethodSignature streamMin;
    public static final MethodSignature streamAvg;
    public static final MethodSignature streamCount;
    public static final MethodSignature streamDistinct;
    public static final MethodSignature streamSelectWithSource;
    public static final MethodSignature streamSelect;
    public static final MethodSignature streamSelectAll;
    public static final MethodSignature streamSelectAllList;
    public static final MethodSignature streamSelectAllWithSource;
    public static final MethodSignature streamWhere;
    public static final MethodSignature streamWhereWithSource;
    public static final MethodSignature streamJoin;
    public static final MethodSignature streamJoinList;
    public static final MethodSignature streamJoinWithSource;
    public static final MethodSignature streamGetOnlyValue;
    public static final MethodSignature streamExists;
    private static final Set<MethodSignature> subqueryMethods;

    MethodChecker(Set<Class<?>> safeMethodAnnotations, Set<MethodSignature> safeMethods, Set<MethodSignature> safeStaticMethods, boolean isObjectEqualsSafe, boolean isAllEqualsSafe, boolean isCollectionContainsSafe) {
        this.safeMethodAnnotations = safeMethodAnnotations;
        this.safeMethods = safeMethods;
        this.safeStaticMethods = safeStaticMethods;
        this.isObjectEqualsSafe = isObjectEqualsSafe;
        this.isAllEqualsSafe = isAllEqualsSafe;
        this.isCollectionContainsSafe = isCollectionContainsSafe;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isStaticMethodSafe(MethodSignature m) {
        if (this.isObjectEqualsSafe && (objectsEquals.equals((Object)m) || guavaObjectsEqual.equals((Object)m))) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        return this.safeStaticMethods.contains(m) || jpqlFunctionStaticMethods.contains(m) ? BasicSymbolicInterpreter.OperationSideEffect.NONE : BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isMethodSafe(MethodSignature m, TypedValue base, List<TypedValue> args) {
        if (this.isAllEqualsSafe && "equals".equals(m.name) && "(Ljava/lang/Object;)Z".equals(m.desc)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        if (this.isObjectEqualsSafe && objectEquals.equals((Object)m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        if (this.safeMethods.contains(m) || subqueryMethods.contains(m) || jpqlFunctionMethods.contains(m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)m);
            if (this.isCollectionContainsSafe && "contains".equals(m.name) && "(Ljava/lang/Object;)Z".equals(m.desc) && Collection.class.isAssignableFrom(reflectedMethod.getDeclaringClass())) {
                return BasicSymbolicInterpreter.OperationSideEffect.NONE;
            }
            if (Annotations.methodHasSomeAnnotations((Method)reflectedMethod, this.safeMethodAnnotations)) {
                return BasicSymbolicInterpreter.OperationSideEffect.NONE;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        return BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public boolean isFluentChaining(MethodSignature sig) {
        return TransformationClassAnalyzer.stringBuilderAppendString.equals((Object)sig);
    }

    public boolean isPutFieldAllowed() {
        return false;
    }

    static {
        mathSqrt = new MethodSignature("java/lang/Math", "sqrt", "(D)D");
        mathAbsDouble = new MethodSignature("java/lang/Math", "abs", "(D)D");
        mathAbsInt = new MethodSignature("java/lang/Math", "abs", "(I)I");
        mathAbsLong = new MethodSignature("java/lang/Math", "abs", "(J)J");
        bigDecimalAbs = new MethodSignature("java/math/BigDecimal", "abs", "()Ljava/math/BigDecimal;");
        bigIntegerAbs = new MethodSignature("java/math/BigInteger", "abs", "()Ljava/math/BigInteger;");
        stringToUpper = new MethodSignature("java/lang/String", "toUpperCase", "()Ljava/lang/String;");
        stringToLower = new MethodSignature("java/lang/String", "toLowerCase", "()Ljava/lang/String;");
        stringValueOfObject = new MethodSignature("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
        stringTrim = new MethodSignature("java/lang/String", "trim", "()Ljava/lang/String;");
        stringLength = new MethodSignature("java/lang/String", "length", "()I");
        stringSubstring = new MethodSignature("java/lang/String", "substring", "(II)Ljava/lang/String;");
        stringIndexOf = new MethodSignature("java/lang/String", "indexOf", "(Ljava/lang/String;)I");
        stringContains = new MethodSignature("java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z");
        stringStartsWith = new MethodSignature("java/lang/String", "startsWith", "(Ljava/lang/String;)Z");
        try {
            jpqlLike = new MethodSignature("org/jinq/jpa/JPQL", "like", "(Ljava/lang/String;Ljava/lang/String;)Z");
            jpqlIsIn = new MethodSignature("org/jinq/jpa/JPQL", "isIn", "(Ljava/lang/Object;Lorg/jinq/orm/stream/JinqStream;)Ljava/lang/Boolean;");
            jpqlIsInList = new MethodSignature("org/jinq/jpa/JPQL", "isInList", "(Ljava/lang/Object;Ljava/util/Collection;)Ljava/lang/Boolean;");
            jpqlListContains = new MethodSignature("org/jinq/jpa/JPQL", "listContains", "(Ljava/util/Collection;Ljava/lang/Object;)Ljava/lang/Boolean;");
            bigDecimalNegate = MethodSignature.fromMethod((Method)BigDecimal.class.getMethod("negate", new Class[0]));
            bigIntegerNegate = MethodSignature.fromMethod((Method)BigInteger.class.getMethod("negate", new Class[0]));
            streamSelectWithSource = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("select", JinqStream.SelectWithSource.class));
            streamSelectAll = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("selectAll", JinqStream.Join.class));
            streamSelectAllWithSource = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("selectAll", JinqStream.JoinWithSource.class));
            streamSelectAllList = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("selectAllList", JinqStream.JoinToIterable.class));
            streamWhereWithSource = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("where", JinqStream.WhereWithSource.class));
            streamJoinList = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("joinList", JinqStream.JoinToIterable.class));
            streamJoinWithSource = MethodSignature.fromMethod((Method)JinqStream.class.getMethod("join", JinqStream.JoinWithSource.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Cannot initialize MethodChecker because it cannot find a needed method", e);
        }
        jpqlFunctionMethods = new HashSet<MethodSignature>();
        jpqlFunctionStaticMethods = new HashSet<MethodSignature>();
        jpqlFunctionStaticMethods.add(jpqlLike);
        jpqlFunctionStaticMethods.add(jpqlIsIn);
        jpqlFunctionStaticMethods.add(jpqlIsInList);
        jpqlFunctionStaticMethods.add(jpqlListContains);
        jpqlFunctionStaticMethods.add(mathSqrt);
        jpqlFunctionStaticMethods.add(mathAbsDouble);
        jpqlFunctionStaticMethods.add(mathAbsInt);
        jpqlFunctionStaticMethods.add(mathAbsLong);
        jpqlFunctionStaticMethods.add(stringValueOfObject);
        jpqlFunctionMethods.add(bigDecimalAbs);
        jpqlFunctionMethods.add(bigIntegerAbs);
        jpqlFunctionMethods.add(bigDecimalNegate);
        jpqlFunctionMethods.add(bigIntegerNegate);
        jpqlFunctionMethods.add(stringToUpper);
        jpqlFunctionMethods.add(stringToLower);
        jpqlFunctionMethods.add(stringTrim);
        jpqlFunctionMethods.add(stringLength);
        jpqlFunctionMethods.add(stringSubstring);
        jpqlFunctionMethods.add(stringIndexOf);
        jpqlFunctionMethods.add(stringContains);
        jpqlFunctionMethods.add(stringStartsWith);
        streamSumInt = TransformationClassAnalyzer.streamSumInt;
        streamSumDouble = TransformationClassAnalyzer.streamSumDouble;
        streamSumLong = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumLong", "(Lorg/jinq/orm/stream/JinqStream$CollectLong;)Ljava/lang/Long;");
        streamSumBigDecimal = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigDecimal", "(Lorg/jinq/orm/stream/JinqStream$CollectBigDecimal;)Ljava/math/BigDecimal;");
        streamSumBigInteger = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigInteger", "(Lorg/jinq/orm/stream/JinqStream$CollectBigInteger;)Ljava/math/BigInteger;");
        streamMax = TransformationClassAnalyzer.streamMax;
        streamMin = TransformationClassAnalyzer.streamMin;
        streamAvg = new MethodSignature("org/jinq/orm/stream/JinqStream", "avg", "(Lorg/jinq/orm/stream/JinqStream$CollectNumber;)Ljava/lang/Double;");
        streamCount = new MethodSignature("org/jinq/orm/stream/JinqStream", "count", "()J");
        streamDistinct = new MethodSignature("org/jinq/orm/stream/JinqStream", "distinct", "()Lorg/jinq/orm/stream/JinqStream;");
        streamSelect = new MethodSignature("org/jinq/orm/stream/JinqStream", "select", "(Lorg/jinq/orm/stream/JinqStream$Select;)Lorg/jinq/orm/stream/JinqStream;");
        streamWhere = new MethodSignature("org/jinq/orm/stream/JinqStream", "where", "(Lorg/jinq/orm/stream/JinqStream$Where;)Lorg/jinq/orm/stream/JinqStream;");
        streamJoin = new MethodSignature("org/jinq/orm/stream/JinqStream", "join", "(Lorg/jinq/orm/stream/JinqStream$Join;)Lorg/jinq/orm/stream/JinqStream;");
        streamGetOnlyValue = new MethodSignature("org/jinq/orm/stream/JinqStream", "getOnlyValue", "()Ljava/lang/Object;");
        streamExists = new MethodSignature("org/jinq/orm/stream/JinqStream", "exists", "()Z");
        subqueryMethods = new HashSet<MethodSignature>();
        subqueryMethods.add(streamSumInt);
        subqueryMethods.add(streamSumDouble);
        subqueryMethods.add(streamSumLong);
        subqueryMethods.add(streamSumBigInteger);
        subqueryMethods.add(streamSumBigDecimal);
        subqueryMethods.add(streamMax);
        subqueryMethods.add(streamMin);
        subqueryMethods.add(streamAvg);
        subqueryMethods.add(streamCount);
        subqueryMethods.add(streamDistinct);
        subqueryMethods.add(streamSelect);
        subqueryMethods.add(streamSelectWithSource);
        subqueryMethods.add(streamSelectAll);
        subqueryMethods.add(streamSelectAllWithSource);
        subqueryMethods.add(streamSelectAllList);
        subqueryMethods.add(streamWhere);
        subqueryMethods.add(streamWhereWithSource);
        subqueryMethods.add(streamJoin);
        subqueryMethods.add(streamJoinWithSource);
        subqueryMethods.add(streamJoinList);
        subqueryMethods.add(streamGetOnlyValue);
        subqueryMethods.add(streamExists);
    }
}

