/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.FromAliasExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.OuterJoinTransform;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;

public class JoinTransform
extends JPQLOneLambdaQueryTransform {
    boolean withSource;
    boolean joinAsPairs;
    boolean isExpectingStream;
    boolean isJoinFetch;

    public JoinTransform(JPQLQueryTransformConfiguration config, boolean withSource, boolean joinAsPairs, boolean isExpectingStream, boolean isJoinFetch) {
        super(config);
        this.withSource = withSource;
        this.isExpectingStream = isExpectingStream;
        this.joinAsPairs = joinAsPairs;
        this.isJoinFetch = isJoinFetch;
    }

    public JoinTransform(JPQLQueryTransformConfiguration config) {
        this(config, false, true, true, false);
    }

    public JoinTransform setWithSource(boolean withSource) {
        this.withSource = withSource;
        return this;
    }

    public JoinTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public JoinTransform setJoinAsPairs(boolean joinAsPairs) {
        this.joinAsPairs = joinAsPairs;
        return this;
    }

    public JoinTransform setIsJoinFetch(boolean isJoinFetch) {
        this.isJoinFetch = isJoinFetch;
        return this;
    }

    static boolean isSimpleFrom(JPQLQuery<?> query) {
        if (!query.isSelectFromWhere()) {
            return false;
        }
        SelectFromWhere sfw = (SelectFromWhere)query;
        if (sfw.where != null) {
            return false;
        }
        if (sfw.froms.size() != 1) {
            return false;
        }
        if (!sfw.cols.isSingleColumn()) {
            return false;
        }
        Expression expr = sfw.cols.getOnlyColumn();
        if (!(expr instanceof FromAliasExpression)) {
            return false;
        }
        return ((FromAliasExpression)expr).from == sfw.froms.get(0);
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, this.withSource), this.isExpectingStream);
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JPQLQuery returnExpr = (JPQLQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods(), this.config.getComparisonStaticMethods(), (boolean)this.config.isAllEqualsSafe).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    if (this.isJoinFetch) {
                        From from = toMerge.froms.get(0);
                        if (!OuterJoinTransform.isLeftOuterJoinCompatible(toMerge)) {
                            throw new QueryTransformException("Left outer join must be applied to a navigational link");
                        }
                        From.FromNavigationalLinksJoinFetch joinFetchFrom = From.forNavigationalLinksJoinFetch((From.FromNavigationalLinks)from);
                        ((SelectFromWhere)toReturn).froms.add(joinFetchFrom);
                        OuterJoinTransform.rewriteFromAliases(toMerge, from, joinFetchFrom);
                    } else {
                        ((SelectFromWhere)toReturn).froms.add(toMerge.froms.get(0));
                    }
                    if (this.joinAsPairs) {
                        ((SelectFromWhere)toReturn).cols = new ColumnExpressions<U>(this.createPairReader(sfw.cols.reader, toMerge.cols.reader));
                        ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                        ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    } else {
                        ((SelectFromWhere)toReturn).cols = toMerge.cols;
                    }
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createPairReader(RowReader<?> a, RowReader<?> b) {
        return TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, a, b);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return JoinTransform.class.getName() + ":" + (this.isJoinFetch ? "1" : "0") + ":" + (this.joinAsPairs ? "1" : "0");
    }
}

