/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import org.jinq.jpa.jpqlquery.BinaryExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.OffsetLambdaIndexInExpressionsVisitor;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JPQLTwoQueryMergeQueryTransform;
import org.jinq.jpa.transform.QueryTransformException;

public class CrossJoinTransform
extends JPQLTwoQueryMergeQueryTransform {
    public CrossJoinTransform(JPQLQueryTransformConfiguration config) {
        super(config);
    }

    @Override
    public <U, V, W> JPQLQuery<W> apply(JPQLQuery<U> query1, JPQLQuery<V> query2, int lambdaOffset) throws QueryTransformException {
        if (query1.isSelectFromWhere() && query2.isSelectFromWhere()) {
            SelectFromWhere sfw1 = (SelectFromWhere)query1;
            SelectFromWhere sfw2 = (SelectFromWhere)query2;
            SelectOnly merged = sfw1.shallowCopy();
            ((SelectFromWhere)merged).cols = new ColumnExpressions(TupleRowReader.createReaderForTuple(((SelectFromWhere)merged).cols.reader, sfw2.cols.reader));
            for (Expression col : sfw1.cols.columns) {
                ((SelectFromWhere)merged).cols.columns.add(col);
            }
            for (Expression col : sfw2.cols.columns) {
                Expression offsetCol = col.copy();
                offsetCol.visit(new OffsetLambdaIndexInExpressionsVisitor(lambdaOffset));
                ((SelectFromWhere)merged).cols.columns.add(offsetCol);
            }
            for (From from : sfw2.froms) {
                ((SelectFromWhere)merged).froms.add(from);
            }
            Expression offsetWhere = sfw2.where.copy();
            offsetWhere.visit(new OffsetLambdaIndexInExpressionsVisitor(lambdaOffset));
            ((SelectFromWhere)merged).where = new BinaryExpression("AND", ((SelectFromWhere)merged).where, offsetWhere);
            return merged;
        }
        throw new QueryTransformException("Cannot cross join these two query streams");
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return CrossJoinTransform.class.getName();
    }
}

