/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.ExpressionVisitor;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;
import org.jinq.jpa.jpqlquery.SelectFromWhere;

public class SubqueryExpression
extends Expression {
    SelectFromWhere<?> subquery;

    public static SubqueryExpression from(SelectFromWhere<?> subquery) {
        SubqueryExpression expr = new SubqueryExpression();
        expr.subquery = subquery;
        return expr;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence = OperatorPrecedenceLevel.JPQL_ORDER_BY_UNRESTRICTED_OPERATOR_PRECEDENCE;
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery("(");
        }
        this.subquery.generateQueryContents(queryState);
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery(")");
        }
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.subquery.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SubqueryExpression o = (SubqueryExpression)obj;
        return this.subquery.equals(o.subquery);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitSubquery(this);
    }

    @Override
    public SubqueryExpression copy() {
        SubqueryExpression expr = new SubqueryExpression();
        expr.subquery = this.subquery.deepCopy();
        return expr;
    }
}

