/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jinq.jpa.jpqlquery.RowReader;

public class CustomTupleRowReader<T>
implements RowReader<T> {
    Method staticBuilder;
    Constructor constructor;
    RowReader<?>[] subreaders;

    public CustomTupleRowReader(Method staticBuilder, Constructor constructor, RowReader<?>[] subreaders) {
        if (staticBuilder == null && constructor == null) {
            throw new IllegalArgumentException("Either a constructor or static method for building the custom tuple is required");
        }
        this.staticBuilder = staticBuilder;
        this.constructor = constructor;
        this.subreaders = subreaders;
    }

    @Override
    public int getNumColumns() {
        int sum = 0;
        for (int n = 0; n < this.subreaders.length; ++n) {
            sum += this.subreaders[n].getNumColumns();
        }
        return sum;
    }

    @Override
    public T readResult(Object result) {
        if (!(result instanceof Object[])) {
            throw new IllegalArgumentException("Expecting an array of results");
        }
        return this.readResult((Object[])result, 0);
    }

    @Override
    public T readResult(Object[] results, int start) {
        Object[] data = new Object[this.subreaders.length];
        int offset = 0;
        for (int n = 0; n < this.subreaders.length; ++n) {
            data[n] = this.subreaders[n].readResult(results, start + offset);
            offset += this.subreaders[n].getNumColumns();
        }
        try {
            if (this.staticBuilder != null) {
                return (T)this.staticBuilder.invoke(null, data);
            }
            return this.constructor.newInstance(data);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot invoke constructor or builder method for custom tuple", e);
        }
    }

    public int getColumnForIndex(int index) {
        if (index < 0 || index >= this.subreaders.length) {
            return -1;
        }
        int offset = 0;
        for (int n = 0; n < index; ++n) {
            offset += this.subreaders[n].getNumColumns();
        }
        return offset;
    }

    public RowReader<?> getReaderForIndex(int index) {
        if (index < 0 || index >= this.subreaders.length) {
            return null;
        }
        return this.subreaders[index];
    }
}

