/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jibx.runtime.impl.IInByteBuffer;

public class InputStreamWrapper {
    private IInByteBuffer m_byteBuffer;
    private String m_encodingName;
    private byte[] m_buffer;
    private int m_endOffset;
    private int m_emptyOffset;
    private int m_scanOffset;

    public void setBuffer(IInByteBuffer buff) {
        this.m_byteBuffer = buff;
        this.m_buffer = buff.getBuffer();
        this.m_endOffset = buff.getLimit();
        this.m_emptyOffset = buff.getOffset();
    }

    public IInByteBuffer getBuffer() {
        return this.m_byteBuffer;
    }

    public void setEncoding(String enc) throws IOException {
        if (this.m_encodingName != null) {
            throw new IOException("Encoding has already been set for stream");
        }
        this.m_encodingName = enc;
    }

    private boolean fillBuffer() throws IOException {
        this.m_byteBuffer.setOffset(this.m_emptyOffset);
        int remain = this.m_endOffset - this.m_emptyOffset;
        boolean result = this.m_byteBuffer.require(remain + 1);
        this.m_buffer = this.m_byteBuffer.getBuffer();
        this.m_endOffset = this.m_byteBuffer.getLimit();
        this.m_emptyOffset = this.m_byteBuffer.getOffset();
        return result;
    }

    private boolean require(int min) throws IOException {
        boolean result = true;
        if (this.m_endOffset - this.m_emptyOffset < min) {
            this.m_byteBuffer.setOffset(this.m_emptyOffset);
            result = this.m_byteBuffer.require(min);
            this.m_buffer = this.m_byteBuffer.getBuffer();
            this.m_endOffset = this.m_byteBuffer.getLimit();
            this.m_emptyOffset = this.m_byteBuffer.getOffset();
        }
        return result;
    }

    private boolean isWhite(int chr) {
        return chr == 32 || chr == 9 || chr == 10 || chr == 13;
    }

    private String scanToken() throws IOException {
        boolean skipping = true;
        StringBuffer buff = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char chr = (char)this.m_buffer[this.m_scanOffset++];
            if (skipping) {
                if (this.isWhite(chr)) continue;
                skipping = false;
                buff.append(chr);
                if (chr != '=') continue;
                return buff.toString();
            }
            if (this.isWhite(chr) || chr == '=') {
                --this.m_scanOffset;
                return buff.toString();
            }
            buff.append(chr);
            if (chr != '>') continue;
            return buff.toString();
        }
        return null;
    }

    private String scanQuoted() throws IOException {
        boolean skipping = true;
        char quot = '\u0000';
        StringBuffer buff = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char chr = (char)this.m_buffer[this.m_scanOffset++];
            if (skipping) {
                if (this.isWhite(chr)) continue;
                if (chr != '\"' && chr != '\'') break;
                skipping = false;
                quot = chr;
                continue;
            }
            if (chr == quot) {
                return buff.toString();
            }
            buff.append(chr);
        }
        return null;
    }

    public Reader getReader() throws IOException {
        if (this.m_encodingName == null) {
            this.m_encodingName = "UTF-8";
            if (this.require(4)) {
                int bom = (((this.m_buffer[0] << 8) + (this.m_buffer[1] & 0xFF) << 8) + (this.m_buffer[2] & 0xFF) << 8) + (this.m_buffer[3] & 0xFF);
                if (bom == 1010792557) {
                    this.m_scanOffset = 2;
                    String token = this.scanToken();
                    if ("xml".equals(token)) {
                        while ((token = this.scanToken()) != null && !"?>".equals(token)) {
                            if ("encoding".equals(token)) {
                                if (!"=".equals(this.scanToken()) || (token = this.scanQuoted()) == null) continue;
                                this.m_encodingName = token;
                                break;
                            }
                            if (!"=".equals(token)) continue;
                            this.scanQuoted();
                        }
                    }
                } else if (bom == 65279 || bom == -131072 || bom == 65534 || bom == -16842752) {
                    this.m_encodingName = "UCS-4";
                } else if ((bom & 0xFFFFFF00) == -272908544) {
                    this.m_encodingName = "UTF-8";
                } else {
                    int upper = bom & 0xFFFF0000;
                    if (upper == -16842752 || bom == 3932223) {
                        this.m_encodingName = "UTF-16BE";
                    } else if (upper == -131072 || bom == 1006649088) {
                        this.m_encodingName = "UTF-16LE";
                    } else if (bom == 1282385812) {
                        this.m_encodingName = "EBCDIC";
                    }
                }
            }
        }
        if (this.m_encodingName.equalsIgnoreCase("UTF-8")) {
            return new WrappedStreamUTF8Reader();
        }
        if (this.m_encodingName.equalsIgnoreCase("ISO-8859-1") || this.m_encodingName.equalsIgnoreCase("ASCII")) {
            return new WrappedStreamISO88591Reader();
        }
        return new InputStreamReader((InputStream)new WrappedStream(), this.m_encodingName);
    }

    public String getEncoding() {
        return this.m_encodingName;
    }

    public void close() throws IOException {
        if (this.m_byteBuffer != null) {
            this.m_byteBuffer.finish();
        }
        this.reset();
    }

    public void reset() {
        this.m_scanOffset = 0;
        this.m_endOffset = 0;
        this.m_emptyOffset = 0;
        this.m_encodingName = null;
    }

    static /* synthetic */ byte[] access$602(InputStreamWrapper x0, byte[] x1) {
        x0.m_buffer = x1;
        return x1;
    }

    private class WrappedStreamISO88591Reader
    extends Reader {
        private WrappedStreamISO88591Reader() {
        }

        @Override
        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int end = off + len;
            int empty = InputStreamWrapper.this.m_emptyOffset;
            byte[] buff = InputStreamWrapper.this.m_buffer;
            while (off < end) {
                int use;
                int avail = InputStreamWrapper.this.m_endOffset - empty;
                if (avail == 0) {
                    InputStreamWrapper.this.m_emptyOffset = empty;
                    if (InputStreamWrapper.this.fillBuffer()) {
                        empty = InputStreamWrapper.this.m_emptyOffset;
                        avail = InputStreamWrapper.this.m_endOffset - empty;
                    } else {
                        int actual = len + off - end;
                        return actual > 0 ? actual : -1;
                    }
                }
                if ((use = end - off) > avail) {
                    use = avail;
                }
                int limit = empty + use;
                while (empty < limit) {
                    b[off++] = (char)(buff[empty++] & 0xFF);
                }
            }
            InputStreamWrapper.this.m_emptyOffset = empty;
            return len;
        }

        @Override
        public int read(char[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0xFF;
        }

        @Override
        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStreamUTF8Reader
    extends Reader {
        private int pendingLowSurrogate;

        private WrappedStreamUTF8Reader() {
        }

        @Override
        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            for (int count = 0; count < len; ++count) {
                int ch = this.read();
                if (ch == -1) {
                    return count > 0 ? count : -1;
                }
                b[off++] = (char)ch;
            }
            return len;
        }

        @Override
        public int read(char[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            int numExtra;
            int value;
            byte first;
            if (this.pendingLowSurrogate != 0) {
                int ch = this.pendingLowSurrogate;
                this.pendingLowSurrogate = 0;
                return ch;
            }
            if (InputStreamWrapper.this.m_emptyOffset + 4 > InputStreamWrapper.this.m_endOffset) {
                InputStreamWrapper.this.fillBuffer();
                if (InputStreamWrapper.this.m_emptyOffset == InputStreamWrapper.this.m_endOffset) {
                    return -1;
                }
            }
            if ((first = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++]) >= 0) {
                return first & 0xFF;
            }
            if ((first & 0xE0) == 192) {
                value = first & 0x1F;
                numExtra = 1;
            } else if ((first & 0xF0) == 224) {
                value = first & 0xF;
                numExtra = 2;
            } else if ((first & 0xF8) == 240) {
                value = first & 7;
                numExtra = 3;
            } else {
                throw new IOException(String.format("%s: invalid first byte 0x%02x", "UTF-8 conversion error", first & 0xFF));
            }
            while (numExtra-- > 0) {
                if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset) {
                    throw new IOException(String.format("%s: truncated code point", "UTF-8 conversion error"));
                }
                byte next = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++];
                if ((next & 0xC0) != 128) {
                    throw new IOException(String.format("%s: invalid extra byte 0x%02x", "UTF-8 conversion error", next & 0xFF));
                }
                value = value << 6 | next & 0x3F;
            }
            if (value >= 65536) {
                if ((value -= 65536) > 1048575) {
                    throw new IOException(String.format("%s: invalid Unicode character 0x%06x", "UTF-8 conversion error", value));
                }
                this.pendingLowSurrogate = 0xDC00 | value & 0x3FF;
                value = 0xD800 | value >> 10;
            }
            return (char)value;
        }

        @Override
        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset + 2 < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStream
    extends InputStream {
        private WrappedStream() {
        }

        @Override
        public int available() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset) {
                InputStreamWrapper.this.m_byteBuffer.require(1);
                InputStreamWrapper.access$602(InputStreamWrapper.this, InputStreamWrapper.this.m_byteBuffer.getBuffer());
                InputStreamWrapper.this.m_emptyOffset = InputStreamWrapper.this.m_byteBuffer.getOffset();
                InputStreamWrapper.this.m_endOffset = InputStreamWrapper.this.m_byteBuffer.getLimit();
            }
            return InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset;
        }

        @Override
        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int avail;
            int actual = 0;
            while (len > (avail = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset)) {
                System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, b, off, avail);
                off += avail;
                len -= avail;
                actual += avail;
                InputStreamWrapper.this.m_emptyOffset = InputStreamWrapper.this.m_endOffset;
                if (InputStreamWrapper.this.fillBuffer()) continue;
                return actual == 0 ? -1 : actual;
            }
            System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, b, off, len);
            InputStreamWrapper.this.m_emptyOffset += len;
            return actual + len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public long skip(long n) throws IOException {
            long remain;
            int avail;
            for (remain = n; remain > (long)(avail = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset); remain -= (long)avail) {
                InputStreamWrapper.this.m_emptyOffset = InputStreamWrapper.this.m_endOffset;
                if (InputStreamWrapper.this.fillBuffer()) continue;
                return n - remain;
            }
            InputStreamWrapper.this.m_emptyOffset = (int)((long)InputStreamWrapper.this.m_emptyOffset + remain);
            return n;
        }

        @Override
        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++];
        }
    }
}

