/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ReadOnlyRequestRepository<R> {
    private final NavigableMap<Long, Entry> requests = new TreeMap<Long, Entry>(Long::compareTo);
    private final Supplier<Integer> majority;
    private final Consumer<Collection<R>> listener;
    private final Consumer<Collection<R>> destroyer;
    private boolean destroyed;

    private ReadOnlyRequestRepository(Supplier<Integer> majority, Consumer<Collection<R>> listener, Consumer<Collection<R>> destroyer) {
        this.majority = majority;
        this.listener = listener;
        this.destroyer = destroyer;
        this.destroyed = false;
    }

    public void destroy() {
        this.destroyed = true;
        for (Entry value : this.requests.values()) {
            this.destroyer.accept(value.requests);
        }
        this.requests.clear();
    }

    public void advance(long index) {
        Iterator it = this.requests.headMap(index, true).entrySet().iterator();
        while (it.hasNext()) {
            Entry v = (Entry)it.next().getValue();
            this.listener.accept(v.requests);
            it.remove();
        }
    }

    public void commit(long index) {
        Iterator it = this.requests.headMap(index, true).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Entry v = (Entry)me.getValue();
            v.accepted();
            if (!v.isCommitted()) continue;
            this.listener.accept(v.requests);
            it.remove();
        }
    }

    public void register(long index, R request) {
        if (this.destroyed) {
            this.destroyer.accept(Collections.singletonList(request));
            return;
        }
        this.requests.compute(index, (k, v) -> {
            if (v == null) {
                return new Entry(request);
            }
            v.include(request);
            return v;
        });
    }

    public static <R> Builder<R> builder(Supplier<Integer> majority) {
        return new Builder(majority);
    }

    private final class Entry {
        private final Collection<R> requests = new ArrayList();
        private int acceptors = 1;

        public Entry(R request) {
            this.requests.add(request);
        }

        public void include(R request) {
            this.requests.add(request);
        }

        public void accepted() {
            ++this.acceptors;
        }

        public boolean isCommitted() {
            return this.acceptors >= ReadOnlyRequestRepository.this.majority.get();
        }
    }

    public static final class Builder<R> {
        private final Supplier<Integer> majority;
        private Consumer<Collection<R>> listener = ignore -> {};
        private Consumer<Collection<R>> destroyer = ignore -> {};

        private Builder(Supplier<Integer> majority) {
            this.majority = majority;
        }

        public Builder<R> withCommitter(Consumer<Collection<R>> committer) {
            this.listener = committer;
            return this;
        }

        public Builder<R> withDestroyer(Consumer<Collection<R>> destroyer) {
            this.destroyer = destroyer;
            return this;
        }

        public ReadOnlyRequestRepository<R> build() {
            return new ReadOnlyRequestRepository<R>(this.majority, this.listener, this.destroyer);
        }
    }
}

