/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.MockRaftCluster;
import org.jgroups.raft.testfwk.RaftNode;

public class PartitionedRaftCluster
extends MockRaftCluster {
    protected final Map<Address, List<Address>> partitions = new ConcurrentHashMap<Address, List<Address>>();
    protected final Map<Address, RaftNode> nodes = new ConcurrentHashMap<Address, RaftNode>();
    private final AtomicBoolean viewChanging = new AtomicBoolean(false);
    private final BlockingQueue<Message> pending = new ArrayBlockingQueue<Message>(16);

    @Override
    public <T extends MockRaftCluster> T clear() {
        this.nodes.clear();
        return this.self();
    }

    @Override
    public <T extends MockRaftCluster> T add(Address addr, RaftNode node) {
        this.nodes.put(addr, node);
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleView(View view) {
        this.viewChanging.set(true);
        try {
            List members = view.getMembers();
            for (Address member : members) {
                this.partitions.put(member, members);
            }
            for (int i = members.size() - 1; i >= 0; --i) {
                Address member;
                member = (Address)members.get(i);
                RaftNode node = this.nodes.get(member);
                node.handleView(view);
            }
        }
        finally {
            this.viewChanging.set(false);
            this.sendPending();
        }
    }

    @Override
    public void send(Message msg) {
        boolean block;
        if (this.viewChanging.get()) {
            this.pending.add(msg);
            return;
        }
        Address dest = msg.dest();
        Address src = msg.src();
        boolean bl = block = this.interceptor != null && this.interceptor.shouldBlock(msg);
        if (block) {
            this.interceptor.blockMessage(msg);
        }
        if (dest != null) {
            List<Address> connected = this.partitions.get(src);
            if (connected.contains(dest)) {
                RaftNode node = this.nodes.get(dest);
                this.send(node, msg);
            }
        } else {
            Collection targets = this.partitions.get(src);
            for (Address a : targets) {
                RaftNode node = this.nodes.get(a);
                this.send(node, msg);
            }
            if (!msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                RaftNode node = this.nodes.get(src);
                this.send(node, msg);
            }
        }
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public <T extends MockRaftCluster> T remove(Address addr) {
        this.nodes.remove(addr);
        return this.self();
    }

    private void send(RaftNode node, Message msg) {
        if (this.async) {
            this.deliverAsync(node, msg);
        } else {
            node.up(msg);
        }
    }

    private void sendPending() {
        Message msg;
        while ((msg = (Message)this.pending.poll()) != null) {
            this.send(msg);
        }
    }
}

