/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import net.jcip.annotations.NotThreadSafe;
import org.jgroups.Address;
import org.jgroups.raft.filelog.FileStorage;
import org.jgroups.util.ByteBufferInputStream;
import org.jgroups.util.Util;

public class MetadataStorage {
    private static final String FILE_NAME = "metadata.raft";
    private static final int COMMIT_INDEX_POS = 0;
    private static final int CURRENT_TERM_POS = 8;
    private static final int VOTED_FOR_POS = 16;
    private final FileStorage fileStorage;
    private ReadWriteWrapper wrapper;
    private boolean fsync;

    public MetadataStorage(File parentDir, boolean fsync) {
        this.fileStorage = new FileStorage(new File(parentDir, FILE_NAME));
        this.fsync = fsync;
    }

    public void useFsync(boolean value) {
        this.fsync = value;
    }

    public boolean useFsync() {
        return this.fsync;
    }

    public void open() throws IOException {
        this.fileStorage.open();
        if (Util.checkForWindows()) {
            FileChannelDelegate rafw = new FileChannelDelegate(new RandomAccessFile(this.fileStorage.getStorageFile(), "rw"));
            this.wrapper = new ReadWriteWrapper(rafw, rafw, rafw, rafw);
        } else {
            MappedByteBuffer mmap = FileChannel.open(this.fileStorage.getStorageFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE).map(FileChannel.MapMode.READ_WRITE, 0L, 16L);
            this.wrapper = new ReadWriteWrapper(mmap::putLong, mmap::getLong, mmap::force, () -> {});
        }
    }

    public void close() throws IOException {
        this.fileStorage.close();
        this.wrapper.close.close();
    }

    public void delete() throws IOException {
        this.fileStorage.delete();
        this.wrapper = null;
    }

    public long getCommitIndex() {
        return this.wrapper.reader.read(0);
    }

    public void setCommitIndex(long commitIndex) throws IOException {
        this.wrapper.writer.write(0, commitIndex);
    }

    public long getCurrentTerm() {
        return this.wrapper.reader.read(8);
    }

    public void setCurrentTerm(long term) throws IOException {
        this.wrapper.writer.write(8, term);
        if (this.fsync) {
            this.wrapper.flush.fsync();
        }
    }

    public Address getVotedFor() throws IOException, ClassNotFoundException {
        ByteBuffer dataLengthBuffer = this.fileStorage.read(16L, 4);
        if (dataLengthBuffer.remaining() != 4) {
            return null;
        }
        int addressLength = dataLengthBuffer.getInt(0);
        ByteBuffer addressLengthBuffer = this.fileStorage.read(20L, addressLength);
        if (addressLengthBuffer.remaining() != addressLength) {
            return null;
        }
        return MetadataStorage.readAddress(addressLengthBuffer);
    }

    public void setVotedFor(Address address) throws IOException {
        if (address == null) {
            this.fileStorage.truncateTo(16L);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.writeAddress((Address)address, (DataOutput)new DataOutputStream(baos));
        byte[] data = baos.toByteArray();
        ByteBuffer buffer = this.fileStorage.ioBufferWith(4 + data.length);
        buffer.putInt(data.length);
        buffer.put(data);
        buffer.flip();
        this.fileStorage.write(16L);
    }

    private static Address readAddress(ByteBuffer buffer) throws IOException, ClassNotFoundException {
        return Util.readAddress((DataInput)new ByteBufferInputStream(buffer));
    }

    @NotThreadSafe
    private static final class FileChannelDelegate
    implements Writer,
    Reader,
    Flush,
    Closeable {
        private final ByteBuffer buffer;
        private final RandomAccessFile raf;
        private final FileChannel channel;

        private FileChannelDelegate(RandomAccessFile raf) {
            this.raf = raf;
            this.channel = raf.getChannel();
            this.buffer = ByteBuffer.allocateDirect(8);
        }

        @Override
        public long read(int position) {
            try {
                this.buffer.rewind();
                this.channel.read(this.buffer, position);
                this.buffer.rewind();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.buffer.getLong();
        }

        @Override
        public void write(int position, long value) {
            this.buffer.rewind();
            this.buffer.putLong(value);
            try {
                this.buffer.flip();
                int w = this.channel.write(this.buffer, position);
                if (w != 8) {
                    throw new IllegalArgumentException("Unable to write value");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
            this.raf.close();
        }

        @Override
        public void fsync() throws IOException {
            this.channel.force(true);
        }
    }

    private static final class ReadWriteWrapper {
        private final Writer writer;
        private final Reader reader;
        private final Flush flush;
        private final Closeable close;

        private ReadWriteWrapper(Writer writer, Reader reader, Flush flush, Closeable close) {
            this.writer = writer;
            this.reader = reader;
            this.flush = flush;
            this.close = close;
        }
    }

    private static interface Writer {
        public void write(int var1, long var2);
    }

    private static interface Reader {
        public long read(int var1);
    }

    private static interface Flush {
        public void fsync() throws IOException;
    }
}

