/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jgroups.blocks.atomic.CounterFunction;
import org.jgroups.raft.Options;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.raft.blocks.RaftAsyncCounter;
import org.jgroups.raft.blocks.RaftSyncCounter;
import org.jgroups.util.AsciiString;
import org.jgroups.util.CompletableFutures;
import org.jgroups.util.Streamable;

public class AsyncCounterImpl
implements RaftAsyncCounter {
    private final CounterService counterService;
    private final AsciiString asciiName;
    private final Sync sync;
    private final Options options;

    public AsyncCounterImpl(CounterService counterService, String name) {
        this(Objects.requireNonNull(counterService), new AsciiString(Objects.requireNonNull(name)), Options.DEFAULT_OPTIONS);
    }

    private AsyncCounterImpl(CounterService counterService, AsciiString asciiName, Options options) {
        assert (counterService != null);
        assert (asciiName != null);
        assert (options != null);
        this.counterService = counterService;
        this.asciiName = asciiName;
        this.options = options;
        this.sync = new Sync();
    }

    public String getName() {
        return this.asciiName.toString();
    }

    public CompletionStage<Long> get() {
        return this.counterService.allowDirtyReads() ? CompletableFuture.completedFuture(this.getLocal()) : this.counterService.asyncGet(this.asciiName);
    }

    @Override
    public long getLocal() {
        return this.counterService._get(this.asciiName.toString());
    }

    public CompletionStage<Void> set(long new_value) {
        return this.counterService.asyncSet(this.asciiName, new_value);
    }

    public CompletionStage<Long> compareAndSwap(long expect, long update) {
        return this.counterService.asyncCompareAndSwap(this.asciiName, expect, update, this.options);
    }

    public CompletionStage<Long> addAndGet(long delta) {
        return this.counterService.asyncAddAndGet(this.asciiName, delta, this.options);
    }

    public <T extends Streamable> CompletionStage<T> update(CounterFunction<T> updateFunction) {
        return this.counterService.asyncUpdate(this.asciiName, updateFunction, this.options);
    }

    @Override
    public RaftSyncCounter sync() {
        return this.sync;
    }

    @Override
    public RaftAsyncCounter async() {
        return this;
    }

    @Override
    public RaftAsyncCounter withOptions(Options opts) {
        if (opts != null && !this.options.equals(opts)) {
            return new AsyncCounterImpl(this.counterService, this.asciiName, opts);
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.getLocal());
    }

    private final class Sync
    implements RaftSyncCounter {
        private Sync() {
        }

        public String getName() {
            return AsyncCounterImpl.this.asciiName.toString();
        }

        public long get() {
            return (Long)CompletableFutures.join(AsyncCounterImpl.this.get());
        }

        @Override
        public long getLocal() {
            return AsyncCounterImpl.this.getLocal();
        }

        public void set(long new_value) {
            CompletableFutures.join(AsyncCounterImpl.this.set(new_value));
        }

        public long compareAndSwap(long expect, long update) {
            CompletionStage<Long> f = AsyncCounterImpl.this.compareAndSwap(expect, update);
            Long retval = (Long)CompletableFutures.join(f);
            return retval == null ? 0L : retval;
        }

        public long addAndGet(long delta) {
            CompletionStage<Long> f = AsyncCounterImpl.this.addAndGet(delta);
            Long retval = (Long)CompletableFutures.join(f);
            return retval == null ? 0L : retval;
        }

        public <T extends Streamable> T update(CounterFunction<T> updateFunction) {
            return (T)((Streamable)CompletableFutures.join(AsyncCounterImpl.this.update(updateFunction)));
        }

        @Override
        public RaftAsyncCounter async() {
            return AsyncCounterImpl.this;
        }

        @Override
        public RaftSyncCounter sync() {
            return this;
        }

        @Override
        public RaftSyncCounter withOptions(Options opts) {
            return AsyncCounterImpl.this.withOptions(opts).sync();
        }

        public String toString() {
            return AsyncCounterImpl.this.toString();
        }
    }
}

