/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util.pmem;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.jgroups.raft.util.pmem.PmemUtilWrapper;

public class FileProvider {
    private static final boolean ATTEMPT_PMEM;

    public static boolean isPMEMAvailable() {
        return ATTEMPT_PMEM;
    }

    public static FileChannel openPMEMChannel(File file, int length, boolean create, boolean readSharedMetadata) throws IOException {
        if (!FileProvider.isPMEMAvailable()) {
            return null;
        }
        return PmemUtilWrapper.pmemChannelFor(file, length, create, readSharedMetadata);
    }

    static {
        boolean attemptPmem = false;
        try {
            Class.forName("io.mashona.logwriting.PmemUtil");
            attemptPmem = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ATTEMPT_PMEM = attemptPmem;
    }
}

