/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jgroups.raft.Options;
import org.jgroups.raft.util.ArrayRingBuffer;

public class RequestTable<T> {
    protected ArrayRingBuffer<Entry<T>> requests;
    private Throwable destroyed;

    public void create(long index, T vote, CompletableFuture<byte[]> future, Supplier<Integer> majority) {
        this.create(index, vote, future, majority, null);
    }

    public void create(long index, T vote, CompletableFuture<byte[]> future, Supplier<Integer> majority, Options opts) {
        Entry<T> entry = new Entry<T>(future, opts);
        if (this.requests == null) {
            this.requests = new ArrayRingBuffer(index);
        }
        this.requests.set(index, entry);
        entry.add(vote, majority);
        if (this.destroyed != null) {
            entry.notify(this.destroyed);
        }
    }

    public void destroy(Throwable t) {
        this.destroyed = t;
        if (this.requests != null) {
            this.requests.forEach((e, ignore) -> {
                if (!e.committed) {
                    e.notify(t);
                }
            });
        }
    }

    public boolean add(long index, T sender, Supplier<Integer> majority) {
        if (this.requests == null) {
            return false;
        }
        boolean added = false;
        for (long i = this.requests.getHeadSequence(); i <= Math.min(index, this.requests.getTailSequence() - 1L); ++i) {
            Entry<T> entry = this.requests.get(i);
            if (entry == null) continue;
            boolean entryAdded = entry.add(sender, majority);
            if (i != index || !entryAdded) continue;
            added = true;
        }
        return added;
    }

    public boolean isCommitted(long index) {
        if (this.requests == null) {
            return false;
        }
        if (index < this.requests.getHeadSequence()) {
            return true;
        }
        Entry<T> entry = this.requests.contains(index) ? this.requests.get(index) : null;
        return entry != null && entry.committed;
    }

    public int size() {
        if (this.requests == null) {
            return 0;
        }
        return this.requests.size(false);
    }

    public Entry<T> remove(long index) {
        return this.requests != null ? this.requests.remove(index) : null;
    }

    public void notifyAndRemove(long index, byte[] response) {
        Entry<T> entry = this.remove(index);
        if (entry != null && entry.client_future != null) {
            entry.client_future.complete(response);
        }
    }

    public String toString() {
        if (this.requests == null || this.requests.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.requests.forEach((entry, index) -> sb.append(index).append(": ").append(entry).append("\n"));
        return sb.toString();
    }

    public static class Entry<T> {
        protected final CompletableFuture<byte[]> client_future;
        protected final Set<T> votes = new HashSet<T>();
        protected final Options opts;
        protected boolean committed;

        public Entry(CompletableFuture<byte[]> client_future, Options opts) {
            this.client_future = client_future;
            this.opts = opts;
        }

        public Options options() {
            return this.opts;
        }

        public boolean add(T vote, Supplier<Integer> majority) {
            return this.votes.add(vote) && this.votes.size() >= majority.get() && this.commit();
        }

        public void notify(byte[] result) {
            if (this.client_future != null) {
                this.client_future.complete(result);
            }
        }

        public void notify(Throwable t) {
            if (this.client_future != null) {
                this.client_future.completeExceptionally(t);
            }
        }

        public boolean commit() {
            boolean prev_committed = this.committed;
            this.committed = true;
            return !prev_committed;
        }

        public String toString() {
            return String.format("committed=%b, votes=%s %s", this.committed, this.votes, this.opts != null ? this.opts.toString() : "");
        }
    }
}

