/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.ObjLongConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.filelog.LogEntryStorage;
import org.jgroups.raft.filelog.MetadataStorage;

public class FileBasedLog
implements Log {
    private static final String SNAPSHOT_FILE_NAME = "state_snapshot.raft";
    private File logDir;
    private Address votedFor;
    private long commitIndex;
    private long currentTerm;
    private static final boolean DEFAULT_FSYNC = true;
    private boolean fsync = true;
    private MetadataStorage metadataStorage;
    private LogEntryStorage logEntryStorage;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        this.logDir = new File(log_name);
        if (!this.logDir.exists() && !this.logDir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory " + this.logDir.getAbsolutePath());
        }
        if (!this.logDir.isDirectory()) {
            throw new IllegalArgumentException("File " + this.logDir.getAbsolutePath() + " is not a directory!");
        }
        this.metadataStorage = new MetadataStorage(this.logDir, this.fsync);
        this.metadataStorage.open();
        this.logEntryStorage = new LogEntryStorage(this.logDir, this.fsync);
        this.logEntryStorage.open();
        this.commitIndex = this.metadataStorage.getCommitIndex();
        this.currentTerm = this.metadataStorage.getCurrentTerm();
        this.votedFor = this.metadataStorage.getVotedFor();
        this.logEntryStorage.reload();
    }

    @Override
    public Log useFsync(boolean value) {
        this.fsync = value;
        if (this.metadataStorage != null) {
            this.metadataStorage.useFsync(value);
        }
        if (this.logEntryStorage != null) {
            this.logEntryStorage.useFsync(value);
        }
        return this;
    }

    @Override
    public boolean useFsync() {
        return this.fsync;
    }

    @Override
    public void close() {
        try {
            LogEntryStorage entryStorage;
            MetadataStorage metadataStorage = this.metadataStorage;
            if (metadataStorage != null) {
                metadataStorage.close();
            }
            if ((entryStorage = this.logEntryStorage) != null) {
                entryStorage.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void delete() {
        try {
            LogEntryStorage entryStorage;
            MetadataStorage storage = this.metadataStorage;
            if (storage != null) {
                storage.delete();
            }
            if ((entryStorage = this.logEntryStorage) != null) {
                entryStorage.delete();
            }
            Files.deleteIfExists(this.snapshotPath());
            if (this.logDir != null) {
                this.logDir.delete();
                this.logDir = null;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long currentTerm() {
        return this.currentTerm;
    }

    @Override
    public Log currentTerm(long new_term) {
        try {
            this.checkMetadataStarted().setCurrentTerm(new_term);
            this.currentTerm = new_term;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Address votedFor() {
        return this.votedFor;
    }

    @Override
    public Log votedFor(Address member) {
        try {
            this.checkMetadataStarted().setVotedFor(member);
            this.votedFor = member;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    @Override
    public Log commitIndex(long new_index) {
        assert (new_index >= this.commitIndex);
        try {
            this.checkMetadataStarted().setCommitIndex(new_index);
            this.commitIndex = new_index;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public long firstAppended() {
        return this.checkLogEntryStorageStarted().getFirstAppended();
    }

    @Override
    public long lastAppended() {
        return this.checkLogEntryStorageStarted().getLastAppended();
    }

    @Override
    public void setSnapshot(ByteBuffer sn) {
        Path snapshotPath = this.snapshotPath();
        try {
            if (Files.exists(snapshotPath, new LinkOption[0])) {
                Path tmp = Files.createTempFile(this.logDir.toPath(), null, null, new FileAttribute[0]);
                FileBasedLog.writeSnapshot(sn, tmp);
                Files.move(tmp, snapshotPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            } else {
                FileBasedLog.writeSnapshot(sn, snapshotPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer getSnapshot() {
        Path snapshotPath = this.snapshotPath();
        if (Files.exists(snapshotPath, new LinkOption[0])) {
            try {
                return ByteBuffer.wrap(Files.readAllBytes(snapshotPath));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Path snapshotPath() {
        return this.logDir.toPath().resolve(SNAPSHOT_FILE_NAME);
    }

    private static void writeSnapshot(ByteBuffer snapshot, Path path) throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            ch.write(snapshot);
        }
    }

    @Override
    public long append(long index, LogEntries entries) {
        assert (index > this.firstAppended());
        assert (index > this.commitIndex());
        LogEntryStorage storage = this.checkLogEntryStorageStarted();
        try {
            long term = storage.write(index, entries);
            if (this.currentTerm != term) {
                this.currentTerm(term);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.lastAppended();
    }

    @Override
    public LogEntry get(long index) {
        try {
            return this.checkLogEntryStorageStarted().getLogEntry(index);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void truncate(long index_exclusive) {
        assert (index_exclusive >= this.firstAppended());
        if (index_exclusive > this.commitIndex) {
            index_exclusive = this.commitIndex;
        }
        try {
            this.checkLogEntryStorageStarted().removeOld(index_exclusive);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reinitializeTo(long index, LogEntry entry) {
        try {
            MetadataStorage metadataStorage = this.checkMetadataStarted();
            this.checkLogEntryStorageStarted().reinitializeTo(index, entry);
            metadataStorage.setCommitIndex(index);
            this.commitIndex = index;
            if (this.currentTerm != entry.term()) {
                metadataStorage.setCurrentTerm(entry.term());
                this.currentTerm = entry.term();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteAllEntriesStartingFrom(long start_index) {
        assert (start_index > this.commitIndex);
        assert (start_index >= this.firstAppended());
        LogEntryStorage storage = this.checkLogEntryStorageStarted();
        try {
            this.currentTerm(storage.removeNew(start_index));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forEach(ObjLongConsumer<LogEntry> function, long start_index, long end_index) {
        try {
            this.checkLogEntryStorageStarted().forEach(function, start_index, end_index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forEach(ObjLongConsumer<LogEntry> function) {
        this.forEach(function, this.firstAppended(), this.lastAppended());
    }

    @Override
    public long sizeInBytes() {
        return this.logEntryStorage.getCachedFileSize();
    }

    public String toString() {
        if (this.logEntryStorage == null) {
            return "FileLog: <not initialized yet>";
        }
        return String.format("FileLog: first=%d, commit=%d, last-appended=%d, term=%d (size=%d)", this.firstAppended(), this.commitIndex(), this.lastAppended(), this.currentTerm, this.size());
    }

    private MetadataStorage checkMetadataStarted() {
        MetadataStorage storage = this.metadataStorage;
        if (storage == null) {
            throw new IllegalStateException("Log not initialized");
        }
        return storage;
    }

    private LogEntryStorage checkLogEntryStorageStarted() {
        LogEntryStorage storage = this.logEntryStorage;
        if (storage == null) {
            throw new IllegalStateException("Log not initialized");
        }
        return storage;
    }
}

