/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;

public class AppendResult
implements Streamable {
    protected Result result;
    protected long index;
    protected long commit_index;
    protected long non_matching_term;

    public AppendResult() {
    }

    public AppendResult(Result result, long index) {
        this.result = result;
        this.index = index;
    }

    public AppendResult(Result result, long index, long non_matching_term) {
        this(result, index);
        this.non_matching_term = non_matching_term;
    }

    public boolean success() {
        return this.result != null && this.result == Result.OK;
    }

    public long index() {
        return this.index;
    }

    public long commitIndex() {
        return this.commit_index;
    }

    public long nonMatchingTerm() {
        return this.non_matching_term;
    }

    public AppendResult commitIndex(long ci) {
        this.commit_index = ci;
        return this;
    }

    public int size() {
        return Bits.size((int)this.result.ordinal()) + Bits.size((long)this.index) + Bits.size((long)this.commit_index) + Bits.size((long)this.non_matching_term);
    }

    public void writeTo(DataOutput out) throws IOException {
        Bits.writeIntCompressed((int)this.result.ordinal(), (DataOutput)out);
        Bits.writeLongCompressed((long)this.index, (DataOutput)out);
        Bits.writeLongCompressed((long)this.commit_index, (DataOutput)out);
        Bits.writeLongCompressed((long)this.non_matching_term, (DataOutput)out);
    }

    public void readFrom(DataInput in) throws IOException {
        int ordinal = Bits.readIntCompressed((DataInput)in);
        this.result = Result.values()[ordinal];
        this.index = Bits.readLongCompressed((DataInput)in);
        this.commit_index = Bits.readLongCompressed((DataInput)in);
        this.non_matching_term = Bits.readLongCompressed((DataInput)in);
    }

    public String toString() {
        return String.format("%b%s, index=%d, commit-index=%d%s", this.success(), this.success() ? "" : String.format(" (%s)", new Object[]{this.result}), this.index, this.commit_index, this.non_matching_term > 0L ? String.format(", non-matching-term=%d", this.non_matching_term) : "");
    }

    public static enum Result {
        OK,
        FAIL_ENTRY_NOT_FOUND,
        FAIL_CONFLICTING_PREV_TERM;

    }
}

