/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.testfwk.RaftTestUtils;

public class Utils {
    public static boolean majorityReached(View old, View new_view, int majority) {
        return (old == null || old.size() < majority) && new_view.size() >= majority;
    }

    public static boolean majorityLost(View old, View new_view, int majority) {
        return old != null && old.size() >= majority && new_view.size() < majority;
    }

    public static Majority computeMajority(View old, View new_view, int majority, Address leader) {
        if (Utils.majorityReached(old, new_view, majority)) {
            return Majority.reached;
        }
        if (Utils.majorityLost(old, new_view, majority)) {
            return Majority.lost;
        }
        if (leader != null && !new_view.containsMember(leader)) {
            return Majority.leader_lost;
        }
        return Majority.no_change;
    }

    public static boolean viewCoordinatorChanged(View prev, View curr) {
        if (prev == null) {
            return true;
        }
        return !Objects.equals(prev.getCoord(), curr.getCoord());
    }

    @Deprecated(since="1.0.13", forRemoval=true)
    public static void deleteLog(RAFT r) throws Exception {
        RaftTestUtils.deleteRaftLog(r);
    }

    public static enum Majority {
        reached,
        lost,
        leader_lost,
        no_change;

    }
}

