/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.election.BaseElection;

public final class RaftTestUtils {
    private RaftTestUtils() {
    }

    public static RAFT raft(JChannel ch) {
        return (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
    }

    public static BaseElection election(JChannel ch) {
        return (BaseElection)ch.getProtocolStack().findProtocol(BaseElection.class);
    }

    public static boolean isRaftLeader(JChannel ch) {
        RAFT r = RaftTestUtils.raft(ch);
        return r.isLeader() && r.leader() != null && ch.getAddress().equals((Object)r.leader());
    }

    public static boolean eventuallyIsRaftLeader(JChannel ch, long timeoutMs) {
        return RaftTestUtils.eventually(() -> RaftTestUtils.isRaftLeader(ch), timeoutMs, TimeUnit.MILLISECONDS);
    }

    public static void deleteRaftLog(RAFT r) throws Exception {
        Log log;
        Log log2 = log = r != null ? r.log() : null;
        if (log != null) {
            log.delete();
            r.log(null);
        }
    }

    public static boolean eventually(BooleanSupplier bs, long timeout, TimeUnit unit) {
        try {
            long initialSleepNanos;
            long timeoutNanos = unit.toNanos(timeout);
            int loops = 30;
            int progressionSum = loops * (loops + 1) / 2;
            long sleepNanos = initialSleepNanos = timeoutNanos / (long)progressionSum;
            long expectedEndTime = System.nanoTime() + timeoutNanos;
            while (expectedEndTime - System.nanoTime() > 0L) {
                if (bs.getAsBoolean()) {
                    return true;
                }
                LockSupport.parkNanos(sleepNanos);
                sleepNanos += initialSleepNanos;
            }
            return bs.getAsBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }
}

