/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.MockRaftCluster;
import org.jgroups.raft.testfwk.RaftNode;

public class PartitionedRaftCluster
extends MockRaftCluster {
    protected final Map<Address, List<Address>> partitions = new ConcurrentHashMap<Address, List<Address>>();
    protected final Map<Address, RaftNode> nodes = new ConcurrentHashMap<Address, RaftNode>();

    @Override
    public <T extends MockRaftCluster> T clear() {
        this.nodes.clear();
        return this.self();
    }

    @Override
    public <T extends MockRaftCluster> T add(Address addr, RaftNode node) {
        this.nodes.put(addr, node);
        return this.self();
    }

    @Override
    public void handleView(View view) {
        List members = view.getMembers();
        for (Address member : members) {
            this.partitions.put(member, members);
        }
        for (Address member : members) {
            RaftNode node = this.nodes.get(member);
            node.handleView(view);
        }
    }

    @Override
    public void send(Message msg) {
        boolean block;
        Address dest = msg.dest();
        Address src = msg.src();
        boolean bl = block = this.interceptor != null && this.interceptor.shouldBlock(msg);
        if (dest != null) {
            List<Object> connected;
            List<Object> list = connected = block ? new ArrayList(this.partitions.get(src)) : this.partitions.get(src);
            if (block) {
                this.interceptor.blockMessage(msg);
            }
            if (connected.contains(dest)) {
                RaftNode node = this.nodes.get(dest);
                this.send(node, msg);
            }
        } else {
            Collection targets;
            Collection collection = targets = block ? new ArrayList(this.partitions.get(src)) : (Collection)this.partitions.get(src);
            if (block) {
                this.interceptor.blockMessage(msg);
            }
            for (Address a : targets) {
                RaftNode node = this.nodes.get(a);
                this.send(node, msg);
            }
            if (!msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                RaftNode node = this.nodes.get(src);
                this.send(node, msg);
            }
        }
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public <T extends MockRaftCluster> T remove(Address addr) {
        this.nodes.remove(addr);
        return this.self();
    }

    private void send(RaftNode node, Message msg) {
        if (this.async) {
            this.deliverAsync(node, msg);
        } else {
            node.up(msg);
        }
    }
}

