/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.BlockingMessageInterceptor;
import org.jgroups.raft.testfwk.RaftNode;

public abstract class MockRaftCluster {
    protected final Executor thread_pool = this.createThreadPool(1000L);
    protected boolean async;
    protected BlockingMessageInterceptor interceptor = null;

    public abstract void handleView(View var1);

    public abstract void send(Message var1);

    public abstract int size();

    public abstract <T extends MockRaftCluster> T add(Address var1, RaftNode var2);

    public abstract <T extends MockRaftCluster> T remove(Address var1);

    public abstract <T extends MockRaftCluster> T clear();

    public BlockingMessageInterceptor addCommandInterceptor(Predicate<Message> predicate) {
        this.interceptor = new BlockingMessageInterceptor(predicate);
        return this.interceptor;
    }

    protected final <T extends MockRaftCluster> T self() {
        return (T)this;
    }

    public boolean async() {
        return this.async;
    }

    public <T extends MockRaftCluster> T async(boolean b) {
        this.async = b;
        return this.self();
    }

    protected Executor createThreadPool(long max_idle_ms) {
        int max_cores = Math.max(Runtime.getRuntime().availableProcessors(), 4);
        return new ThreadPoolExecutor(0, max_cores, max_idle_ms, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    protected void deliverAsync(RaftNode node, Message msg) {
        this.thread_pool.execute(() -> node.up(msg));
    }
}

