/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;

public abstract class RaftImpl {
    protected RAFT raft;

    public RaftImpl(RAFT raft) {
        this.raft = raft;
    }

    public RAFT raft() {
        return this.raft;
    }

    public RaftImpl raft(RAFT r) {
        this.raft = r;
        return this;
    }

    public void init() {
    }

    public void destroy() {
    }

    public AppendResult handleAppendEntriesRequest(LogEntries entries, Address leader, long prev_index, long prev_term, long entry_term, long leader_commit) {
        this.raft.leader(leader);
        long curr_index = prev_index + 1L;
        if (entries == null || curr_index <= this.raft.commitIndex()) {
            this.raft.commitLogTo(leader_commit, false);
            return new AppendResult(AppendResult.Result.OK, this.raft.lastAppended()).commitIndex(this.raft.commitIndex());
        }
        LogEntry prev = this.raft.log_impl.get(prev_index);
        if (prev == null && prev_index > 0L) {
            ++this.raft.num_failed_append_requests_not_found;
            return new AppendResult(AppendResult.Result.FAIL_ENTRY_NOT_FOUND, this.raft.lastAppended());
        }
        if (prev_index == 0L || prev.term == prev_term) {
            boolean added;
            LogEntry existing = this.raft.log_impl.get(curr_index);
            if (existing != null && existing.term != entry_term) {
                this.raft.deleteAllLogEntriesStartingFrom(curr_index);
            }
            int num_added = (added = this.raft.append(curr_index, entries)) ? entries.size() : 0;
            this.raft.commitLogTo(leader_commit, false);
            this.raft.num_successful_append_requests += num_added;
            return new AppendResult(AppendResult.Result.OK, added ? prev_index + (long)num_added : this.raft.lastAppended()).commitIndex(this.raft.commitIndex());
        }
        ++this.raft.num_failed_append_requests_wrong_term;
        long conflicting_index = this.getFirstIndexOfConflictingTerm(prev_index, prev.term);
        if (conflicting_index <= this.raft.commitIndex()) {
            this.raft.getLog().error("%s: cannot delete entries <= %d as commit_index is higher: log=%s", new Object[]{this.raft.getAddress(), conflicting_index, this.raft.log_impl});
            conflicting_index = this.raft.last_appended;
        } else {
            this.raft.deleteAllLogEntriesStartingFrom(conflicting_index);
        }
        return new AppendResult(AppendResult.Result.FAIL_CONFLICTING_PREV_TERM, conflicting_index, prev.term).commitIndex(this.raft.commitIndex());
    }

    public void handleAppendEntriesResponse(Address sender, long term, AppendResult result) {
    }

    public void handleInstallSnapshotRequest(Message msg, Address leader, long last_included_index, long last_included_term) {
    }

    protected long getFirstIndexOfConflictingTerm(long start_index, long conflicting_term) {
        LogEntry entry;
        long retval;
        Log log = this.raft.log_impl;
        long first = Math.max(1L, log.firstAppended());
        long last = log.lastAppended();
        long commit_index = log.commitIndex();
        long i = retval = Math.min(start_index, last);
        while (i >= first && i > commit_index && (entry = log.get(i)) != null && entry.term == conflicting_term) {
            retval = i--;
        }
        return retval;
    }
}

