/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class LogEntry
implements SizeStreamable {
    protected long term;
    protected byte[] command;
    protected int offset;
    protected int length;
    protected boolean internal;

    public LogEntry() {
    }

    public LogEntry(long term, byte[] command) {
        this(term, command, 0, command != null ? command.length : 0);
    }

    public LogEntry(long term, byte[] command, int offset, int length) {
        this(term, command, offset, length, false);
    }

    public LogEntry(long term, byte[] command, int offset, int length, boolean internal) {
        this.term = term;
        this.command = command;
        this.offset = offset;
        this.length = length;
        this.internal = internal;
    }

    public long term() {
        return this.term;
    }

    public LogEntry term(long t) {
        this.term = t;
        return this;
    }

    public byte[] command() {
        return this.command;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public boolean internal() {
        return this.internal;
    }

    public LogEntry internal(boolean b) {
        this.internal = b;
        return this;
    }

    public int serializedSize() {
        int retval = Bits.size((long)this.term) + 2;
        if (this.command != null) {
            retval += 4 + this.length();
        }
        return retval;
    }

    public void writeTo(DataOutput out) throws IOException {
        Bits.writeLongCompressed((long)this.term, (DataOutput)out);
        Util.writeByteBuffer((byte[])this.command, (int)this.offset, (int)this.length, (DataOutput)out);
        out.writeBoolean(this.internal);
    }

    public void readFrom(DataInput in) throws IOException {
        this.term = Bits.readLongCompressed((DataInput)in);
        this.command = Util.readByteBuffer((DataInput)in);
        this.offset = 0;
        this.length = this.command != null ? this.command.length : 0;
        this.internal = in.readBoolean();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("term=").append(this.term).append(" (").append(this.command != null ? this.command.length : 0).append(" bytes)");
        if (this.internal) {
            str.append(" [internal]");
        }
        return str.toString();
    }
}

