/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.demos;

import java.io.Closeable;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.util.Util;

public class CounterServiceDemo {
    protected JChannel ch;
    protected CounterService counter_service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String props, String name, long repl_timeout, boolean allow_dirty_reads, boolean follower) throws Exception {
        this.ch = new JChannel(props).name(name);
        this.counter_service = new CounterService(this.ch).raftId(name).replTimeout(repl_timeout).allowDirtyReads(allow_dirty_reads);
        if (follower) {
            CounterServiceDemo.disableElections(this.ch);
        }
        this.ch.setReceiver((Receiver)new ReceiverAdapter(){

            public void viewAccepted(View view) {
                System.out.println("-- view: " + view);
            }
        });
        try {
            this.ch.connect("cntrs");
            this.loop();
        }
        finally {
            Util.close((Closeable)this.ch);
        }
    }

    protected void loop() throws Exception {
        Counter counter = this.counter_service.counter("counter");
        boolean looping = true;
        while (looping) {
            try {
                int key = Util.keyPress((String)("[0] Initialize counter [1] Increment [2] Decrement [3] Compare and set\n[4] Dump log [8] Snapshot [9] Increment N times [x] Exit\nfirst-applied=" + this.firstApplied() + ", last-applied=" + this.counter_service.lastApplied() + ", commit-index=" + this.counter_service.commitIndex() + ", log size=" + Util.printBytes((long)this.logSize()) + "\n"));
                switch (key) {
                    case 48: {
                        long initial_value = Util.readLongFromStdin((String)"initial value: ");
                        this.counter_service.getOrCreateCounter("counter", initial_value);
                        break;
                    }
                    case 49: {
                        long val = counter.incrementAndGet();
                        System.out.printf("%s: %s\n", counter.getName(), val);
                        break;
                    }
                    case 50: {
                        long val = counter.decrementAndGet();
                        System.out.printf("%s: %s\n", counter.getName(), val);
                        break;
                    }
                    case 51: {
                        long expect = Util.readLongFromStdin((String)"expected value: ");
                        long update = Util.readLongFromStdin((String)"update: ");
                        if (counter.compareAndSet(expect, update)) {
                            System.out.println("-- set counter \"" + counter.getName() + "\" to " + update + "\n");
                            break;
                        }
                        System.err.println("failed setting counter \"" + counter.getName() + "\" from " + expect + " to " + update + ", current value is " + counter.get() + "\n");
                        break;
                    }
                    case 52: {
                        this.dumpLog();
                        break;
                    }
                    case 56: {
                        this.counter_service.snapshot();
                        break;
                    }
                    case 57: {
                        int NUM = Util.readIntFromStdin((String)"num: ");
                        System.out.println("");
                        int print = NUM / 10;
                        long retval = 0L;
                        long start = System.currentTimeMillis();
                        for (int i = 0; i < NUM; ++i) {
                            retval = counter.incrementAndGet();
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + retval);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.println("\n" + NUM + " incrs took " + diff + " ms; " + (double)NUM / ((double)diff / 1000.0) + " ops /sec\n");
                        break;
                    }
                    case 120: {
                        looping = false;
                        break;
                    }
                    case 10: {
                        System.out.println(counter.getName() + ": " + counter.get() + "\n");
                    }
                }
            }
            catch (Throwable t) {
                System.err.println(t.toString());
            }
        }
    }

    protected void dumpLog() {
        System.out.println("\nindex (term): command\n---------------------");
        this.counter_service.dumpLog();
        System.out.println("");
    }

    protected int firstApplied() {
        RAFT raft = (RAFT)this.ch.getProtocolStack().findProtocol(RAFT.class);
        return raft.log().firstAppended();
    }

    protected int logSize() {
        return this.counter_service.logSize();
    }

    protected static void disableElections(JChannel ch) {
        ELECTION election = (ELECTION)ch.getProtocolStack().findProtocol(ELECTION.class);
        if (election != null) {
            election.noElections(true);
        }
    }

    public static void main(String[] args) throws Exception {
        String properties = "raft.xml";
        String name = null;
        long repl_timeout = 5000L;
        boolean allow_dirty_reads = true;
        boolean follower = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                properties = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("repl_timeout")) {
                repl_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-allow_dirty_reads")) {
                allow_dirty_reads = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-follower")) {
                follower = true;
                continue;
            }
            CounterServiceDemo.help();
            return;
        }
        new CounterServiceDemo().start(properties, name, repl_timeout, allow_dirty_reads, follower);
    }

    private static void help() {
        System.out.println("CounterServiceDemo [-props props] [-name name] [-repl_timeout timeout] [-follower] [-allow_dirty_reads true|false]");
    }
}

