/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.PolynomialFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010\u0010\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nJ\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialFunction;", "", "c", "", "([D)V", "coefficients", "apply_op", "other", "op", "Lkotlin/Function2;", "", "compareTo", "", "degree", "equals", "", "evaluate", "argument", "hashCode", "minus", "multiply", "a", "plus", "times", "toString", "", "unaryMinus", "unaryPlus", "value", "x", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPolynomialFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolynomialFunction.kt\norg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialFunction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,233:1\n1807#2,6:234\n*S KotlinDebug\n*F\n+ 1 PolynomialFunction.kt\norg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialFunction\n*L\n174#1:234,6\n*E\n"})
public final class PolynomialFunction {
    @NotNull
    private double[] coefficients;

    public PolynomialFunction(@Nullable double[] c) {
        int n;
        if (c == null || c.length == 0) {
            throw new IllegalStateException("Empty polynomials coefficients array".toString());
        }
        for (n = c.length; n > 1 && c[n - 1] == 0.0; --n) {
        }
        this.coefficients = new double[n];
        ArraysKt.copyInto((double[])c, (double[])this.coefficients, (int)0, (int)0, (int)n);
    }

    public final double value(double x) {
        return this.evaluate(this.coefficients, x);
    }

    private final double evaluate(double[] coefficients, double argument) {
        if (coefficients == null) {
            throw new IllegalStateException("Null argument: coefficients of the polynomial to evaluate".toString());
        }
        int n = coefficients.length;
        if (n == 0) {
            throw new IllegalStateException("Empty polynomials coefficients array".toString());
        }
        double result = coefficients[n - 1];
        for (int j = n - 2; -1 < j; --j) {
            result = argument * result + coefficients[j];
        }
        return result;
    }

    @NotNull
    public final PolynomialFunction unaryPlus() {
        return new PolynomialFunction(this.coefficients);
    }

    @NotNull
    public final PolynomialFunction unaryMinus() {
        double[] dd = new double[this.coefficients.length];
        double[] dArray = this.coefficients;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            double c = dArray[i];
            dd[i2] = -c;
        }
        return new PolynomialFunction(dd);
    }

    private final PolynomialFunction apply_op(PolynomialFunction other, Function2<? super Double, ? super Double, Double> op) {
        int sz = Math.max(this.coefficients.length, other.coefficients.length);
        double[] nc = new double[sz];
        for (int i = 0; i < sz; ++i) {
            double a2 = i < this.coefficients.length ? this.coefficients[i] : 0.0;
            double b2 = i < other.coefficients.length ? other.coefficients[i] : 0.0;
            nc[i] = ((Number)op.invoke((Object)a2, (Object)b2)).doubleValue();
        }
        return new PolynomialFunction(nc);
    }

    @NotNull
    public final PolynomialFunction plus(@NotNull PolynomialFunction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.apply_op(other, (Function2<? super Double, ? super Double, Double>)((Function2)plus.1.INSTANCE));
    }

    @NotNull
    public final PolynomialFunction minus(@NotNull PolynomialFunction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.apply_op(other, (Function2<? super Double, ? super Double, Double>)((Function2)minus.1.INSTANCE));
    }

    @NotNull
    public final PolynomialFunction multiply(double a2) {
        double[] dd = new double[this.coefficients.length];
        double[] dArray = this.coefficients;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            double c = dArray[i];
            dd[i2] = a2 * c;
        }
        return new PolynomialFunction(dd);
    }

    @NotNull
    public final PolynomialFunction times(@NotNull PolynomialFunction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int nd = this.coefficients.length + other.coefficients.length - 1;
        double[] nc = new double[nd];
        block0: for (int i = 0; i < nd; ++i) {
            int j = 0;
            if (j > i) continue;
            while (true) {
                double a2 = j < this.coefficients.length ? this.coefficients[j] : 0.0;
                int k = i - j;
                double b2 = k < other.coefficients.length ? other.coefficients[k] : 0.0;
                int n = i;
                nc[n] = nc[n] + a2 * b2;
                if (j == i) continue block0;
                ++j;
            }
        }
        return new PolynomialFunction(nc);
    }

    public final int degree() {
        int n;
        int n2;
        block2: {
            n2 = 0;
            double[] $this$indexOfLast$iv = this.coefficients;
            boolean $i$f$indexOfLast = false;
            int n3 = $this$indexOfLast$iv.length + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    double it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!(!(it == 0.0))) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n3);
            }
            n = -1;
        }
        int n4 = n;
        return Math.max(n2, n4);
    }

    public final int compareTo(@NotNull PolynomialFunction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int d1 = this.degree();
        int d2 = other.degree();
        int n = Math.min(d1, d2) + 1;
        for (int i = 0; i < n; ++i) {
            double a2 = this.coefficients[i];
            double b2 = other.coefficients[i];
            int res = Double.compare(a2, b2);
            if (res == 0) continue;
            return res;
        }
        return Intrinsics.compare((int)d1, (int)d2);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof PolynomialFunction)) {
            return false;
        }
        return this.compareTo((PolynomialFunction)other) == 0;
    }

    public int hashCode() {
        return this.coefficients.hashCode();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = ArraysKt.getLastIndex((double[])this.coefficients); -1 < i; --i) {
            if (this.coefficients[i] == 0.0) continue;
            if (!(((CharSequence)sb).length() == 0)) {
                sb.append(" + ");
            }
            sb.append(String.valueOf(this.coefficients[i]));
            if (i > 0) {
                sb.append("x");
            }
            if (i <= 1) continue;
            sb.append("^").append(i);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

