/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.geometry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J\u0016\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification;", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "()V", "isEmpty", "", "()Z", "isSimplificationDone", "myTriangles", "", "Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "myVerticesToRemove", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "add", "", "triangle", "getIndex", "getWeights", "", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "initTriangles", "peek", "poll", "takeTriangle", "update", "Companion", "Triangle", "plot-base"})
@SourceDebugExtension(value={"SMAP\nVisvalingamWhyattSimplification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisvalingamWhyattSimplification.kt\norg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n1855#3,2:161\n*S KotlinDebug\n*F\n+ 1 VisvalingamWhyattSimplification.kt\norg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification\n*L\n82#1:161,2\n*E\n"})
public final class VisvalingamWhyattSimplification
implements PolylineSimplifier.RankingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Integer> myVerticesToRemove = new ArrayList();
    @Nullable
    private List<Triangle> myTriangles;
    private static final double INITIAL_AREA = Double.MAX_VALUE;

    private final boolean isSimplificationDone() {
        return this.isEmpty();
    }

    private final boolean isEmpty() {
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        return list2.isEmpty();
    }

    @Override
    @NotNull
    public List<Double> getWeights(@NotNull List<DoubleVector> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.myTriangles = new ArrayList(points.size() - 2);
        this.initTriangles(points);
        int n = points.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(INITIAL_AREA);
        }
        List weights = arrayList;
        double lastRemovedVertexArea = 0.0;
        while (!this.isSimplificationDone()) {
            Triangle prev;
            Triangle triangle = this.takeTriangle();
            lastRemovedVertexArea = triangle.getArea() > lastRemovedVertexArea ? triangle.getArea() : lastRemovedVertexArea;
            weights.set(triangle.getCurrentVertex(), lastRemovedVertexArea);
            Triangle next = triangle.getNext();
            if (next != null) {
                next.takePrevFrom$plot_base(triangle);
                this.update(next);
            }
            if ((prev = triangle.getPrev()) != null) {
                prev.takeNextFrom$plot_base(triangle);
                this.update(prev);
            }
            this.myVerticesToRemove.add(triangle.getCurrentVertex());
        }
        return weights;
    }

    private final void initTriangles(List<DoubleVector> points) {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(points.size() - 2);
        VisvalingamWhyattSimplification $this$initTriangles_u24lambda_u241 = this;
        boolean bl = false;
        int n = points.size() - 1;
        for (int i = 1; i < n; ++i) {
            triangles.add(new Triangle(i, points));
        }
        int n2 = triangles.size() - 1;
        for (int i = 1; i < n2; ++i) {
            ((Triangle)triangles.get(i)).setNext((Triangle)triangles.get(i + 1));
            ((Triangle)triangles.get(i)).setPrev((Triangle)triangles.get(i - 1));
        }
        Iterable $this$forEach$iv = triangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triangle it = (Triangle)element$iv;
            boolean bl2 = false;
            this.add(it);
        }
    }

    private final Triangle takeTriangle() {
        Triangle minimalTriangle = this.poll();
        this.myVerticesToRemove.add(minimalTriangle.getCurrentVertex());
        return minimalTriangle;
    }

    private final void add(Triangle triangle) {
        int index = this.getIndex(triangle);
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        list2.add(index, triangle);
    }

    private final int getIndex(Triangle triangle) {
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        int index = CollectionsKt.binarySearch$default(list2, (Object)triangle, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Triangle it = (Triangle)a2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getArea());
                it = (Triangle)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getArea()));
            }
        }, (int)0, (int)0, (int)12, null);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        return index;
    }

    private final Triangle peek() {
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        return list2.get(0);
    }

    private final Triangle poll() {
        Triangle triangle = this.peek();
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        list2.remove(triangle);
        return triangle;
    }

    private final void update(Triangle triangle) {
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        list2.remove(triangle);
        List<Triangle> list3 = this.myTriangles;
        Intrinsics.checkNotNull(list3);
        list3.add(triangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Companion;", "", "()V", "INITIAL_AREA", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\tH\u0002J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001fR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "", "currentVertex", "", "myPoints", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(ILjava/util/List;)V", "<set-?>", "", "area", "getArea", "()D", "getCurrentVertex", "()I", "next", "getNext", "()Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;", "setNext", "(Lorg/jetbrains/letsPlot/core/commons/geometry/VisvalingamWhyattSimplification$Triangle;)V", "nextVertex", "prev", "getPrev", "setPrev", "prevVertex", "calculateArea", "takeNextFrom", "", "triangle", "takeNextFrom$plot_base", "takePrevFrom", "takePrevFrom$plot_base", "plot-base"})
    private static final class Triangle {
        private final int currentVertex;
        @NotNull
        private final List<DoubleVector> myPoints;
        private double area;
        private int prevVertex;
        private int nextVertex;
        @Nullable
        private Triangle prev;
        @Nullable
        private Triangle next;

        public Triangle(int currentVertex, @NotNull List<DoubleVector> myPoints) {
            Intrinsics.checkNotNullParameter(myPoints, (String)"myPoints");
            this.currentVertex = currentVertex;
            this.myPoints = myPoints;
            this.prevVertex = this.currentVertex - 1;
            this.nextVertex = this.currentVertex + 1;
            this.area = this.calculateArea();
        }

        public final int getCurrentVertex() {
            return this.currentVertex;
        }

        public final double getArea() {
            return this.area;
        }

        @Nullable
        public final Triangle getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Triangle triangle) {
            this.prev = triangle;
        }

        @Nullable
        public final Triangle getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Triangle triangle) {
            this.next = triangle;
        }

        public final void takeNextFrom$plot_base(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.next = triangle.next;
            this.nextVertex = triangle.nextVertex;
            this.area = this.calculateArea();
        }

        public final void takePrevFrom$plot_base(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.prev = triangle.prev;
            this.prevVertex = triangle.prevVertex;
            this.area = this.calculateArea();
        }

        private final double calculateArea() {
            DoubleVector a2 = this.myPoints.get(this.prevVertex);
            DoubleVector b2 = this.myPoints.get(this.currentVertex);
            DoubleVector c = this.myPoints.get(this.nextVertex);
            return Math.abs(((b2.getX() - a2.getX()) * (c.getY() - a2.getY()) - (c.getX() - a2.getX()) * (b2.getY() - a2.getY())) / 2.0);
        }
    }
}

