/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.BaseWriter;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutForWriter;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImplKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bH\u0016J\u0014\u0010&\u001a\u00020#2\n\u0010'\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010(\u001a\u00020#H\u0016J8\u0010)\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/library/impl/BaseWriterImpl;", "Lorg/jetbrains/kotlin/library/BaseWriter;", "libraryLayout", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "moduleName", "", "_versions", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "builtInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "nativeTargets", "", "nopack", "", "shortName", "(Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;Ljava/util/List;ZLjava/lang/String;)V", "klibFile", "Lorg/jetbrains/kotlin/konan/file/File;", "getKlibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLibraryLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "manifestProperties", "Ljava/util/Properties;", "Lorg/jetbrains/kotlin/konan/properties/Properties;", "getManifestProperties", "()Ljava/util/Properties;", "getNopack", "()Z", "getShortName", "()Ljava/lang/String;", "versions", "getVersions", "()Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "addLinkDependencies", "", "libraries", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "addManifestAddend", "properties", "commit", "initManifestProperties", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKotlinLibraryWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLibraryWriterImpl.kt\norg/jetbrains/kotlin/library/impl/BaseWriterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1#2:191\n1563#3:192\n1634#3,3:193\n*S KotlinDebug\n*F\n+ 1 KotlinLibraryWriterImpl.kt\norg/jetbrains/kotlin/library/impl/BaseWriterImpl\n*L\n77#1:192\n77#1:193,3\n*E\n"})
public final class BaseWriterImpl
implements BaseWriter {
    @NotNull
    private final KotlinLibraryLayoutForWriter libraryLayout;
    private final boolean nopack;
    @Nullable
    private final String shortName;
    @NotNull
    private final File klibFile;
    @NotNull
    private final Properties manifestProperties;
    @NotNull
    private final KotlinLibraryVersioning versions;

    public BaseWriterImpl(@NotNull KotlinLibraryLayoutForWriter libraryLayout, @NotNull String moduleName, @NotNull KotlinLibraryVersioning _versions, @NotNull BuiltInsPlatform builtInsPlatform, @NotNull List<String> nativeTargets, boolean nopack, @Nullable String shortName) {
        Intrinsics.checkNotNullParameter((Object)libraryLayout, (String)"libraryLayout");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)_versions, (String)"_versions");
        Intrinsics.checkNotNullParameter((Object)((Object)builtInsPlatform), (String)"builtInsPlatform");
        Intrinsics.checkNotNullParameter(nativeTargets, (String)"nativeTargets");
        this.libraryLayout = libraryLayout;
        this.nopack = nopack;
        this.shortName = shortName;
        this.klibFile = this.libraryLayout.getLibFile().getCanonicalFile();
        this.manifestProperties = new Properties();
        this.versions = _versions;
        this.klibFile.deleteRecursively();
        File $this$_init__u24lambda_u240 = this.klibFile.getParentFile();
        boolean bl = false;
        if (!$this$_init__u24lambda_u240.getExists()) {
            $this$_init__u24lambda_u240.mkdirs();
        }
        this.libraryLayout.getResourcesDir().mkdirs();
        this.initManifestProperties(moduleName, this.getVersions(), builtInsPlatform, nativeTargets, this.shortName);
    }

    public /* synthetic */ BaseWriterImpl(KotlinLibraryLayoutForWriter kotlinLibraryLayoutForWriter, String string2, KotlinLibraryVersioning kotlinLibraryVersioning, BuiltInsPlatform builtInsPlatform, List list, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        this(kotlinLibraryLayoutForWriter, string2, kotlinLibraryVersioning, builtInsPlatform, list, bl, string3);
    }

    @NotNull
    public final KotlinLibraryLayoutForWriter getLibraryLayout() {
        return this.libraryLayout;
    }

    public final boolean getNopack() {
        return this.nopack;
    }

    @Nullable
    public final String getShortName() {
        return this.shortName;
    }

    @NotNull
    public final File getKlibFile() {
        return this.klibFile;
    }

    @NotNull
    public final Properties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    @NotNull
    public KotlinLibraryVersioning getVersions() {
        return this.versions;
    }

    private final void initManifestProperties(String moduleName, KotlinLibraryVersioning _versions, BuiltInsPlatform builtInsPlatform, List<String> nativeTargets, String shortName) {
        block2: {
            this.manifestProperties.setProperty("unique_name", moduleName);
            KotlinLibraryVersioningKt.writeKonanLibraryVersioning(this.manifestProperties, _versions);
            if (builtInsPlatform != BuiltInsPlatform.COMMON) {
                this.manifestProperties.setProperty("builtins_platform", builtInsPlatform.name());
            }
            if (builtInsPlatform == BuiltInsPlatform.NATIVE) {
                this.manifestProperties.setProperty("native_targets", CollectionsKt.joinToString$default((Iterable)nativeTargets, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            String string2 = shortName;
            if (string2 == null) break block2;
            String it = string2;
            boolean bl = false;
            this.manifestProperties.setProperty("short_name", it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLinkDependencies(@NotNull List<? extends KotlinLibrary> libraries) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        if (libraries.isEmpty()) {
            this.manifestProperties.remove("depends");
            return;
        }
        Iterable $this$map$iv = libraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)it));
        }
        String newValue = KotlinLibraryWriterImplKt.toSpaceSeparatedString((List)destination$iv$iv);
        this.manifestProperties.setProperty("depends", newValue);
    }

    @Override
    public void addManifestAddend(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.manifestProperties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void commit() {
        PropertiesKt.saveToFile((Properties)this.manifestProperties, (File)this.libraryLayout.getManifestFile());
        if (!this.nopack) {
            ZipUtilKt.zipDirAs((File)this.libraryLayout.getUnzippedDir(), (File)this.klibFile);
            this.libraryLayout.getUnzippedDir().deleteRecursively();
        }
    }
}

