/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolverKt;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolver;
import org.jetbrains.kotlin.library.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.library.resolver.impl.KotlinLibraryResolverResultImpl;
import org.jetbrains.kotlin.library.resolver.impl.KotlinResolvedLibraryImpl;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.WithLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001d\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J.\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0016\u0010 \u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\u0012\u0010#\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/library/resolver/impl/KotlinLibraryResolverImpl;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolver;", "Lorg/jetbrains/kotlin/util/WithLogger;", "searchPathResolver", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "resolveManifestDependenciesLenient", "", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;Z)V", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "getResolveManifestDependenciesLenient", "()Z", "getSearchPathResolver", "()Lorg/jetbrains/kotlin/library/SearchPathResolver;", "findLibraries", "", "unresolvedLibraries", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "resolveWithDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "warnOnLibraryDuplicateNames", "", "duplicatedPaths", "", "", "warnOnLibraryDuplicates", "leaveDistinct", "omitDuplicateNames", "resolveDependencies", "kotlin-util-klib-metadata"})
public final class KotlinLibraryResolverImpl<L extends KotlinLibrary>
implements KotlinLibraryResolver<L>,
WithLogger {
    @NotNull
    private final SearchPathResolver<L> searchPathResolver;
    private final boolean resolveManifestDependenciesLenient;

    public KotlinLibraryResolverImpl(@NotNull SearchPathResolver<L> searchPathResolver, boolean resolveManifestDependenciesLenient) {
        Intrinsics.checkNotNullParameter(searchPathResolver, (String)"searchPathResolver");
        this.searchPathResolver = searchPathResolver;
        this.resolveManifestDependenciesLenient = resolveManifestDependenciesLenient;
    }

    @Override
    @NotNull
    public SearchPathResolver<L> getSearchPathResolver() {
        return this.searchPathResolver;
    }

    public final boolean getResolveManifestDependenciesLenient() {
        return this.resolveManifestDependenciesLenient;
    }

    @NotNull
    public Logger getLogger() {
        return this.searchPathResolver.getLogger();
    }

    @Override
    @NotNull
    public KotlinLibraryResolveResult resolveWithDependencies(@NotNull List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        Intrinsics.checkNotNullParameter(unresolvedLibraries, (String)"unresolvedLibraries");
        return this.resolveDependencies(this.omitDuplicateNames(this.leaveDistinct(this.findLibraries(unresolvedLibraries, noStdLib, noDefaultLibs, noEndorsedLibs))));
    }

    private final List<KotlinLibrary> findLibraries(List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List userProvidedLibraries2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)unresolvedLibraries), (Function1)new Function1<UnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final L invoke(@NotNull UnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (L)SearchPathResolverKt.resolve(this.this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
            }
        }));
        List defaultLibraries = this.getSearchPathResolver().defaultLinks(noStdLib, noDefaultLibs, noEndorsedLibs);
        return CollectionsKt.plus((Collection)userProvidedLibraries2, (Iterable)defaultLibraries);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> leaveDistinct(List<? extends KotlinLibrary> $this$leaveDistinct) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$leaveDistinct;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = it.getLibraryFile().getAbsolutePath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map groupedByAbsolutePath = destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = groupedByAbsolutePath;
        Object object = this;
        boolean $i$f$filter = false;
        element$iv$iv2 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = iterator.next();
            boolean bl3 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicates(destination$iv$iv2.keySet());
        Map $this$map$iv = groupedByAbsolutePath;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry it = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl4 = false;
            object.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> omitDuplicateNames(List<? extends KotlinLibrary> $this$omitDuplicateNames) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$omitDuplicateNames;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)it));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map groupedByUniqName = destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = groupedByUniqName;
        Object object = this;
        boolean $i$f$filter = false;
        element$iv$iv2 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = iterator.next();
            boolean bl3 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicateNames(destination$iv$iv2.keySet());
        Map $this$map$iv = groupedByUniqName;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry it = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl4 = false;
            object.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
        }
        return (List)destination$iv$iv2;
    }

    private final void warnOnLibraryDuplicates(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.getLogger().warning("library included more than once: " + it);
        }
    }

    private final void warnOnLibraryDuplicateNames(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.getLogger().warning("duplicate library name: " + it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinLibraryResolveResult resolveDependencies(List<? extends KotlinLibrary> $this$resolveDependencies) {
        Collection destination$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = $this$resolveDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new KotlinResolvedLibraryImpl((KotlinLibrary)it));
        }
        List rootLibraries = (List)destination$iv$iv2;
        KotlinLibraryResolverResultImpl result = new KotlinLibraryResolverResultImpl(rootLibraries);
        Map cache = new LinkedHashMap();
        $this$mapTo$iv$iv2 = rootLibraries;
        object = cache;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl = (KotlinResolvedLibraryImpl)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getLibrary().getLibraryFile().getCanonicalFile(), (Object)it));
        }
        MapsKt.putAll((Map)object, (Iterable)((List)destination$iv$iv3));
        List newDependencies = rootLibraries;
        do {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = newDependencies;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void library;
                KotlinResolvedLibraryImpl bl = (KotlinResolvedLibraryImpl)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)KotlinLibraryKt.unresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)library.getLibrary()), (boolean)this.resolveManifestDependenciesLenient)), (Function1)((Function1)new Function1<UnresolvedLibrary, Boolean>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull UnresolvedLibrary it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.getSearchPathResolver().isProvidedByDefault(it);
                    }
                })), (Function1)((Function1)new Function1<UnresolvedLibrary, KotlinResolvedLibraryImpl>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final KotlinResolvedLibraryImpl invoke(@NotNull UnresolvedLibrary it) {
                        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        KotlinLibrary kotlinLibrary = SearchPathResolverKt.resolve(this.this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
                        if (kotlinLibrary != null) {
                            KotlinLibrary p0 = kotlinLibrary;
                            boolean bl = false;
                            kotlinResolvedLibraryImpl = new KotlinResolvedLibraryImpl(p0);
                        } else {
                            kotlinResolvedLibraryImpl = null;
                        }
                        return kotlinResolvedLibraryImpl;
                    }
                })), (Function1)((Function1)new Function1<KotlinResolvedLibraryImpl, KotlinResolvedLibraryImpl>((Map<File, KotlinResolvedLibrary>)cache, (KotlinResolvedLibraryImpl)library){
                    final /* synthetic */ Map<File, KotlinResolvedLibrary> $cache;
                    final /* synthetic */ KotlinResolvedLibraryImpl $library;
                    {
                        this.$cache = $cache;
                        this.$library = $library;
                        super(1);
                    }

                    @Nullable
                    public final KotlinResolvedLibraryImpl invoke(@NotNull KotlinResolvedLibraryImpl resolved) {
                        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
                        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
                        File canonicalFile = resolved.getLibrary().getLibraryFile().getCanonicalFile();
                        if (this.$cache.containsKey(canonicalFile)) {
                            KotlinResolvedLibrary kotlinResolvedLibrary = this.$cache.get(canonicalFile);
                            Intrinsics.checkNotNull((Object)kotlinResolvedLibrary);
                            this.$library.addDependency$kotlin_util_klib_metadata(kotlinResolvedLibrary);
                            kotlinResolvedLibraryImpl = null;
                        } else {
                            this.$cache.put(canonicalFile, resolved);
                            this.$library.addDependency$kotlin_util_klib_metadata(resolved);
                            kotlinResolvedLibraryImpl = resolved;
                        }
                        return kotlinResolvedLibraryImpl;
                    }
                })))));
            }
        } while (!((Collection)(newDependencies = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)))).isEmpty());
        return result;
    }
}

