package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import java.util.*

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Array<out T>.contains(element: T) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun BooleanArray.contains(element: Boolean) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun ByteArray.contains(element: Byte) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun CharArray.contains(element: Char) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun DoubleArray.contains(element: Double) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun FloatArray.contains(element: Float) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun IntArray.contains(element: Int) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun LongArray.contains(element: Long) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun ShortArray.contains(element: Short) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Iterable<T>.contains(element: T) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Stream<T>.contains(element: T) : Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns element at given *index*
 */
public fun <T> Array<out T>.elementAt(index : Int) : T {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun BooleanArray.elementAt(index : Int) : Boolean {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun ByteArray.elementAt(index : Int) : Byte {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun CharArray.elementAt(index : Int) : Char {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun DoubleArray.elementAt(index : Int) : Double {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun FloatArray.elementAt(index : Int) : Float {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun IntArray.elementAt(index : Int) : Int {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun LongArray.elementAt(index : Int) : Long {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun ShortArray.elementAt(index : Int) : Short {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun <T> Iterable<T>.elementAt(index : Int) : T {
    if (this is List<*>)
        return get(index) as T
    val iterator = iterator()
    var count = 0
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (index == count++)
            return element
    }
    throw IndexOutOfBoundsException("Collection doesn't contain element at index")
    
}

/**
 * Returns element at given *index*
 */
public fun <T> List<T>.elementAt(index : Int) : T {
    return get(index)
    
}

/**
 * Returns element at given *index*
 */
public fun <T> Stream<T>.elementAt(index : Int) : T {
    val iterator = iterator()
    var count = 0
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (index == count++)
            return element
    }
    throw IndexOutOfBoundsException("Collection doesn't contain element at index")
    
}

/**
 * Returns first element
 */
public fun <T> Array<out T>.first() : T {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun BooleanArray.first() : Boolean {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun ByteArray.first() : Byte {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun CharArray.first() : Char {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun DoubleArray.first() : Double {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun FloatArray.first() : Float {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun IntArray.first() : Int {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun LongArray.first() : Long {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun ShortArray.first() : Short {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun <T> Iterable<T>.first() : T {
    val iterator = iterator()
    if (!iterator.hasNext())
        throw IllegalArgumentException("Collection is empty")
    return iterator.next()
    
}

/**
 * Returns first element
 */
public fun <T> List<T>.first() : T {
    return this[0]
    
}

/**
 * Returns first element
 */
public fun <T> Stream<T>.first() : T {
    val iterator = iterator()
    if (!iterator.hasNext())
        throw IllegalArgumentException("Collection is empty")
    return iterator.next()
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Array<out T>.first(predicate: (T) -> Boolean) : T {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun BooleanArray.first(predicate: (Boolean) -> Boolean) : Boolean {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun ByteArray.first(predicate: (Byte) -> Boolean) : Byte {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun CharArray.first(predicate: (Char) -> Boolean) : Char {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun DoubleArray.first(predicate: (Double) -> Boolean) : Double {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun FloatArray.first(predicate: (Float) -> Boolean) : Float {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun IntArray.first(predicate: (Int) -> Boolean) : Int {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun LongArray.first(predicate: (Long) -> Boolean) : Long {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun ShortArray.first(predicate: (Short) -> Boolean) : Short {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Iterable<T>.first(predicate: (T) -> Boolean) : T {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Stream<T>.first(predicate: (T) -> Boolean) : T {
    for (element in this) if (predicate(element)) return element
    throw IllegalArgumentException("No element matching predicate was found")
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun <T> Array<out T>.firstOrNull() : T? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun BooleanArray.firstOrNull() : Boolean? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun ByteArray.firstOrNull() : Byte? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun CharArray.firstOrNull() : Char? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun DoubleArray.firstOrNull() : Double? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun FloatArray.firstOrNull() : Float? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun IntArray.firstOrNull() : Int? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun LongArray.firstOrNull() : Long? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun ShortArray.firstOrNull() : Short? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun <T> Iterable<T>.firstOrNull() : T? {
    val iterator = iterator()
    if (!iterator.hasNext())
        return null
    return iterator.next()
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun <T> List<T>.firstOrNull() : T? {
    return if (size > 0) this[0] else null
    
}

/**
 * Returns first elementm, or null if collection is empty
 */
public fun <T> Stream<T>.firstOrNull() : T? {
    val iterator = iterator()
    if (!iterator.hasNext())
        return null
    return iterator.next()
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Array<out T>.firstOrNull(predicate: (T) -> Boolean) : T? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun BooleanArray.firstOrNull(predicate: (Boolean) -> Boolean) : Boolean? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun ByteArray.firstOrNull(predicate: (Byte) -> Boolean) : Byte? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun CharArray.firstOrNull(predicate: (Char) -> Boolean) : Char? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun DoubleArray.firstOrNull(predicate: (Double) -> Boolean) : Double? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun FloatArray.firstOrNull(predicate: (Float) -> Boolean) : Float? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun IntArray.firstOrNull(predicate: (Int) -> Boolean) : Int? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun LongArray.firstOrNull(predicate: (Long) -> Boolean) : Long? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun ShortArray.firstOrNull(predicate: (Short) -> Boolean) : Short? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Iterable<T>.firstOrNull(predicate: (T) -> Boolean) : T? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Stream<T>.firstOrNull(predicate: (T) -> Boolean) : T? {
    for (element in this) if (predicate(element)) return element
    return null
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Array<out T>.indexOf(element: T) : Int {
    if (element == null) {
        for (index in indices) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun BooleanArray.indexOf(element: Boolean) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun ByteArray.indexOf(element: Byte) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun CharArray.indexOf(element: Char) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun DoubleArray.indexOf(element: Double) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun FloatArray.indexOf(element: Float) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun IntArray.indexOf(element: Int) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun LongArray.indexOf(element: Long) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun ShortArray.indexOf(element: Short) : Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Iterable<T>.indexOf(element: T) : Int {
    var index = 0
    for (item in this) {
        if (element == item)
            return index
        index++
    }
    return -1
    
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Stream<T>.indexOf(element: T) : Int {
    var index = 0
    for (item in this) {
        if (element == item)
            return index
        index++
    }
    return -1
    
}

/**
 * Returns last element
 */
public fun <T> Array<out T>.last() : T {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun BooleanArray.last() : Boolean {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun ByteArray.last() : Byte {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun CharArray.last() : Char {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun DoubleArray.last() : Double {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun FloatArray.last() : Float {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun IntArray.last() : Int {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun LongArray.last() : Long {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun ShortArray.last() : Short {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun <T> Iterable<T>.last() : T {
    when (this) {
        is List<*> -> return this[size - 1] as T
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw IllegalArgumentException("Collection is empty")
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
    
}

/**
 * Returns last element
 */
public fun <T> List<T>.last() : T {
    if (size == 0)
        throw IllegalArgumentException("Collection is empty")
    return this[size - 1]
    
}

/**
 * Returns last element
 */
public fun <T> Stream<T>.last() : T {
    when (this) {
        is List<*> -> return this[size - 1] as T
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw IllegalArgumentException("Collection is empty")
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun <T> Array<out T>.last(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun BooleanArray.last(predicate: (Boolean) -> Boolean) : Boolean {
    fun first(it : Iterator<Boolean>) : Boolean {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun ByteArray.last(predicate: (Byte) -> Boolean) : Byte {
    fun first(it : Iterator<Byte>) : Byte {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun CharArray.last(predicate: (Char) -> Boolean) : Char {
    fun first(it : Iterator<Char>) : Char {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun DoubleArray.last(predicate: (Double) -> Boolean) : Double {
    fun first(it : Iterator<Double>) : Double {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun FloatArray.last(predicate: (Float) -> Boolean) : Float {
    fun first(it : Iterator<Float>) : Float {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun IntArray.last(predicate: (Int) -> Boolean) : Int {
    fun first(it : Iterator<Int>) : Int {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun LongArray.last(predicate: (Long) -> Boolean) : Long {
    fun first(it : Iterator<Long>) : Long {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun ShortArray.last(predicate: (Short) -> Boolean) : Short {
    fun first(it : Iterator<Short>) : Short {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun <T> Iterable<T>.last(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*
 */
public fun <T> Stream<T>.last(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't contain any element matching predicate")
    }
    val iterator = iterator()
    var last = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Array<out T>.lastIndexOf(element: T) : Int {
    if (element == null) {
        for (index in indices.reverse()) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices.reverse()) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun BooleanArray.lastIndexOf(element: Boolean) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun ByteArray.lastIndexOf(element: Byte) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun CharArray.lastIndexOf(element: Char) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun DoubleArray.lastIndexOf(element: Double) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun FloatArray.lastIndexOf(element: Float) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun IntArray.lastIndexOf(element: Int) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun LongArray.lastIndexOf(element: Long) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun ShortArray.lastIndexOf(element: Short) : Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Iterable<T>.lastIndexOf(element: T) : Int {
    var lastIndex = -1
    var index = 0
    for (item in this) {
        if (element == item)
            lastIndex = index
        index++
    }
    return lastIndex
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> List<T>.lastIndexOf(element: T) : Int {
    if (element == null) {
        for (index in indices.reverse()) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices.reverse()) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
    
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Stream<T>.lastIndexOf(element: T) : Int {
    var lastIndex = -1
    var index = 0
    for (item in this) {
        if (element == item)
            lastIndex = index
        index++
    }
    return lastIndex
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Array<out T>.lastOrNull() : T? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun BooleanArray.lastOrNull() : Boolean? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun ByteArray.lastOrNull() : Byte? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun CharArray.lastOrNull() : Char? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun DoubleArray.lastOrNull() : Double? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun FloatArray.lastOrNull() : Float? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun IntArray.lastOrNull() : Int? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun LongArray.lastOrNull() : Long? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun ShortArray.lastOrNull() : Short? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Iterable<T>.lastOrNull() : T? {
    when (this) {
        is List<*> -> return if (size > 0) this[size - 1] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> List<T>.lastOrNull() : T? {
    return if (size > 0) this[size - 1] else null
    
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Stream<T>.lastOrNull() : T? {
    when (this) {
        is List<*> -> return if (size > 0) this[size - 1] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun <T> Array<out T>.lastOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun BooleanArray.lastOrNull(predicate: (Boolean) -> Boolean) : Boolean? {
    fun first(it : Iterator<Boolean>) : Boolean? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun ByteArray.lastOrNull(predicate: (Byte) -> Boolean) : Byte? {
    fun first(it : Iterator<Byte>) : Byte? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun CharArray.lastOrNull(predicate: (Char) -> Boolean) : Char? {
    fun first(it : Iterator<Char>) : Char? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun DoubleArray.lastOrNull(predicate: (Double) -> Boolean) : Double? {
    fun first(it : Iterator<Double>) : Double? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun FloatArray.lastOrNull(predicate: (Float) -> Boolean) : Float? {
    fun first(it : Iterator<Float>) : Float? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun IntArray.lastOrNull(predicate: (Int) -> Boolean) : Int? {
    fun first(it : Iterator<Int>) : Int? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun LongArray.lastOrNull(predicate: (Long) -> Boolean) : Long? {
    fun first(it : Iterator<Long>) : Long? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun ShortArray.lastOrNull(predicate: (Short) -> Boolean) : Short? {
    fun first(it : Iterator<Short>) : Short? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun <T> Iterable<T>.lastOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public fun <T> Stream<T>.lastOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var last = first(iterator)
    if (last == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            last = element
    }
    return last
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Array<out T>.single() : T {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun BooleanArray.single() : Boolean {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun ByteArray.single() : Byte {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun CharArray.single() : Char {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun DoubleArray.single() : Double {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun FloatArray.single() : Float {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun IntArray.single() : Int {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun LongArray.single() : Long {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun ShortArray.single() : Short {
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Iterable<T>.single() : T {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else throw IllegalArgumentException("Collection has $size elements")
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw IllegalArgumentException("Collection is empty")
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
    
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Stream<T>.single() : T {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else throw IllegalArgumentException("Collection has $size elements")
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw IllegalArgumentException("Collection is empty")
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun <T> Array<out T>.single(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun BooleanArray.single(predicate: (Boolean) -> Boolean) : Boolean {
    fun first(it : Iterator<Boolean>) : Boolean {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun ByteArray.single(predicate: (Byte) -> Boolean) : Byte {
    fun first(it : Iterator<Byte>) : Byte {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun CharArray.single(predicate: (Char) -> Boolean) : Char {
    fun first(it : Iterator<Char>) : Char {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun DoubleArray.single(predicate: (Double) -> Boolean) : Double {
    fun first(it : Iterator<Double>) : Double {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun FloatArray.single(predicate: (Float) -> Boolean) : Float {
    fun first(it : Iterator<Float>) : Float {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun IntArray.single(predicate: (Int) -> Boolean) : Int {
    fun first(it : Iterator<Int>) : Int {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun LongArray.single(predicate: (Long) -> Boolean) : Long {
    fun first(it : Iterator<Long>) : Long {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun ShortArray.single(predicate: (Short) -> Boolean) : Short {
    fun first(it : Iterator<Short>) : Short {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun <T> Iterable<T>.single(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public fun <T> Stream<T>.single(predicate: (T) -> Boolean) : T {
    fun first(it : Iterator<T>) : T {
        for (element in it) if (predicate(element)) return element
        throw IllegalArgumentException("Collection doesn't have matching element")
    }
    val iterator = iterator()
    var single = first(iterator)
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Array<out T>.singleOrNull() : T? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun BooleanArray.singleOrNull() : Boolean? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun ByteArray.singleOrNull() : Byte? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun CharArray.singleOrNull() : Char? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun DoubleArray.singleOrNull() : Double? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun FloatArray.singleOrNull() : Float? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun IntArray.singleOrNull() : Int? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun LongArray.singleOrNull() : Long? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun ShortArray.singleOrNull() : Short? {
    if (size == 0)
        return null
    if (size != 1)
        throw IllegalArgumentException("Collection has $size elements")
    return this[0]
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Iterable<T>.singleOrNull() : T? {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else if (size == 0) null else throw IllegalArgumentException("Collection has $size elements")
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
    
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Stream<T>.singleOrNull() : T? {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else if (size == 0) null else throw IllegalArgumentException("Collection has $size elements")
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun <T> Array<out T>.singleOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun BooleanArray.singleOrNull(predicate: (Boolean) -> Boolean) : Boolean? {
    fun first(it : Iterator<Boolean>) : Boolean? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun ByteArray.singleOrNull(predicate: (Byte) -> Boolean) : Byte? {
    fun first(it : Iterator<Byte>) : Byte? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun CharArray.singleOrNull(predicate: (Char) -> Boolean) : Char? {
    fun first(it : Iterator<Char>) : Char? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun DoubleArray.singleOrNull(predicate: (Double) -> Boolean) : Double? {
    fun first(it : Iterator<Double>) : Double? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun FloatArray.singleOrNull(predicate: (Float) -> Boolean) : Float? {
    fun first(it : Iterator<Float>) : Float? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun IntArray.singleOrNull(predicate: (Int) -> Boolean) : Int? {
    fun first(it : Iterator<Int>) : Int? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun LongArray.singleOrNull(predicate: (Long) -> Boolean) : Long? {
    fun first(it : Iterator<Long>) : Long? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun ShortArray.singleOrNull(predicate: (Short) -> Boolean) : Short? {
    fun first(it : Iterator<Short>) : Short? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun <T> Iterable<T>.singleOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public fun <T> Stream<T>.singleOrNull(predicate: (T) -> Boolean) : T? {
    fun first(it : Iterator<T>) : T? {
        for (element in it) if (predicate(element)) return element
        return null
    }
    val iterator = iterator()
    var single = first(iterator)
    if (single == null)
        return null
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (predicate(element))
            throw IllegalArgumentException("Collection has more than one matching element")
    }
    return single
    
}

