/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KParameter;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KPackageImpl;
import kotlin.reflect.jvm.internal.KotlinKProperty;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.ReflectKCallable;
import kotlin.reflect.jvm.internal.ReflectKCallableKt;
import kotlin.reflect.jvm.internal.ReflectKProperty;
import kotlin.reflect.jvm.internal.ReflectKPropertyKt;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.CallerImpl;
import kotlin.reflect.jvm.internal.calls.InternalUnderlyingValOfInlineClass;
import kotlin.reflect.jvm.internal.calls.ThrowingCaller;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCallerKt;
import kotlin.reflect.jvm.internal.impl.km.ClassKind;
import kotlin.reflect.jvm.internal.impl.km.KmProperty;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmAttributes;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmExtensionsKt;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\nH\u0002\"\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"boundReceiver", "", "Lkotlin/reflect/jvm/internal/KotlinKProperty$Accessor;", "getBoundReceiver", "(Lkotlin/reflect/jvm/internal/KotlinKProperty$Accessor;)Ljava/lang/Object;", "computeCallerForAccessor", "Lkotlin/reflect/jvm/internal/calls/Caller;", "isGetter", "", "isJvmFieldPropertyInCompanionObject", "Lkotlin/reflect/jvm/internal/KotlinKProperty;", "kotlin-reflection"})
@SourceDebugExtension(value={"SMAP\nKotlinKProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinKProperty.kt\nkotlin/reflect/jvm/internal/KotlinKPropertyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
public final class KotlinKPropertyKt {
    @Nullable
    public static final Object getBoundReceiver(@NotNull KotlinKProperty.Accessor<?, ?> $this$boundReceiver) {
        Intrinsics.checkNotNullParameter($this$boundReceiver, (String)"<this>");
        return ReflectKCallableKt.getBoundReceiver((ReflectKCallable)$this$boundReceiver.getProperty());
    }

    @NotNull
    public static final Caller<?> computeCallerForAccessor(@NotNull KotlinKProperty.Accessor<?, ?> $this$computeCallerForAccessor, boolean isGetter) {
        Caller caller;
        Method method;
        JvmMethodSignature accessorSignature;
        Intrinsics.checkNotNullParameter($this$computeCallerForAccessor, (String)"<this>");
        KotlinKProperty<?> property = $this$computeCallerForAccessor.getProperty();
        if (ReflectKPropertyKt.isLocalDelegated((ReflectKProperty)property)) {
            return ThrowingCaller.INSTANCE;
        }
        KmProperty kmProperty = property.getKmProperty();
        JvmMethodSignature jvmMethodSignature = accessorSignature = isGetter ? JvmExtensionsKt.getGetterSignature(kmProperty) : JvmExtensionsKt.getSetterSignature(kmProperty);
        if (jvmMethodSignature != null) {
            JvmMethodSignature signature = jvmMethodSignature;
            boolean bl = false;
            method = property.getContainer().findMethodBySignature(signature.getName(), signature.getDescriptor());
        } else {
            method = null;
        }
        Method accessor = method;
        if (accessor == null) {
            if (ValueClassAwareCallerKt.isUnderlyingPropertyOfValueClass((ReflectKProperty)property) && property.getVisibility() == KVisibility.INTERNAL) {
                GenericDeclaration genericDeclaration = ValueClassAwareCallerKt.toInlineClass(((KParameter)CollectionsKt.single(property.getParameters())).getType());
                if (genericDeclaration == null || (genericDeclaration = ValueClassAwareCallerKt.getInlineClassUnboxMethod(genericDeclaration, (ReflectKCallable)property)) == null) {
                    throw new KotlinReflectionInternalError("Underlying property of inline class " + property + " should have a field");
                }
                GenericDeclaration unboxMethod = genericDeclaration;
                caller = ReflectKCallableKt.isBound((ReflectKCallable)$this$computeCallerForAccessor) ? (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Bound((Method)unboxMethod, KotlinKPropertyKt.getBoundReceiver($this$computeCallerForAccessor)) : (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Unbound((Method)unboxMethod);
            } else {
                Field field = property.getJavaField();
                if (field == null) {
                    throw new KotlinReflectionInternalError("No accessors or field is found for property " + property);
                }
                Field javaField = field;
                caller = KotlinKPropertyKt.computeCallerForAccessor$computeFieldCaller(property, isGetter, $this$computeCallerForAccessor, javaField);
            }
        } else {
            caller = !Modifier.isStatic(accessor.getModifiers()) ? (Caller)(ReflectKCallableKt.isBound((ReflectKCallable)$this$computeCallerForAccessor) ? (CallerImpl.Method)new CallerImpl.Method.BoundInstance(accessor, KotlinKPropertyKt.getBoundReceiver($this$computeCallerForAccessor)) : (CallerImpl.Method)new CallerImpl.Method.Instance(accessor)) : (KotlinKPropertyKt.computeCallerForAccessor$isJvmStaticProperty($this$computeCallerForAccessor) ? (Caller)(ReflectKCallableKt.isBound((ReflectKCallable)$this$computeCallerForAccessor) ? (CallerImpl.Method)new CallerImpl.Method.BoundJvmStaticInObject(accessor) : (CallerImpl.Method)new CallerImpl.Method.JvmStaticInObject(accessor)) : (Caller)(ReflectKCallableKt.isBound((ReflectKCallable)$this$computeCallerForAccessor) ? (CallerImpl.Method)new CallerImpl.Method.BoundStatic(accessor, false, KotlinKPropertyKt.getBoundReceiver($this$computeCallerForAccessor)) : (CallerImpl.Method)new CallerImpl.Method.Static(accessor)));
        }
        return ValueClassAwareCallerKt.createValueClassAwareCallerIfNeeded(caller, (ReflectKCallable)$this$computeCallerForAccessor, false, CollectionsKt.emptyList());
    }

    private static final boolean isJvmFieldPropertyInCompanionObject(KotlinKProperty<?> $this$isJvmFieldPropertyInCompanionObject) {
        KDeclarationContainerImpl container = $this$isJvmFieldPropertyInCompanionObject.getContainer();
        if (!(container instanceof KClassImpl) || ((KClassImpl)container).getClassKind$kotlin_reflection() != ClassKind.COMPANION_OBJECT) {
            return false;
        }
        Class<?> clazz = JvmClassMappingKt.getJavaClass((KClass)((KClass)container)).getEnclosingClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getEnclosingClass(...)");
        KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
        KClassImpl kClassImpl = kClass instanceof KClassImpl ? (KClassImpl)kClass : null;
        if (kClassImpl == null) {
            return false;
        }
        KClassImpl outerClass = kClassImpl;
        return outerClass.getClassKind$kotlin_reflection() == ClassKind.INTERFACE || outerClass.getClassKind$kotlin_reflection() == ClassKind.ANNOTATION_CLASS ? JvmAttributes.isMovedFromInterfaceCompanion($this$isJvmFieldPropertyInCompanionObject.getKmProperty()) : true;
    }

    private static final boolean computeCallerForAccessor$isJvmStaticProperty(KotlinKProperty.Accessor<?, ?> $this_computeCallerForAccessor) {
        if (!($this_computeCallerForAccessor.getContainer() instanceof KPackageImpl)) {
            boolean bl = false;
            String string = "Only top-level properties are supported for now: " + $this_computeCallerForAccessor;
            throw new IllegalArgumentException(string.toString());
        }
        return false;
    }

    private static final boolean computeCallerForAccessor$isNotNullProperty(KotlinKProperty<? extends Object> property) {
        return !UtilKt.isNullableType(property.getReturnType());
    }

    private static final CallerImpl<Field> computeCallerForAccessor$computeFieldCaller(KotlinKProperty<? extends Object> property, boolean $isGetter, KotlinKProperty.Accessor<?, ?> $this_computeCallerForAccessor, Field field) {
        return KotlinKPropertyKt.isJvmFieldPropertyInCompanionObject(property) || !Modifier.isStatic(field.getModifiers()) ? ($isGetter ? (CallerImpl)(ReflectKCallableKt.isBound((ReflectKCallable)$this_computeCallerForAccessor) ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundInstance(field, KotlinKPropertyKt.getBoundReceiver($this_computeCallerForAccessor)) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.Instance(field)) : (ReflectKCallableKt.isBound((ReflectKCallable)$this_computeCallerForAccessor) ? (CallerImpl)new CallerImpl.FieldSetter.BoundInstance(field, KotlinKPropertyKt.computeCallerForAccessor$isNotNullProperty(property), KotlinKPropertyKt.getBoundReceiver($this_computeCallerForAccessor)) : (CallerImpl)new CallerImpl.FieldSetter.Instance(field, KotlinKPropertyKt.computeCallerForAccessor$isNotNullProperty(property)))) : (KotlinKPropertyKt.computeCallerForAccessor$isJvmStaticProperty($this_computeCallerForAccessor) ? ($isGetter ? (CallerImpl)(ReflectKCallableKt.isBound((ReflectKCallable)$this_computeCallerForAccessor) ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundJvmStaticInObject(field) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.JvmStaticInObject(field)) : (ReflectKCallableKt.isBound((ReflectKCallable)$this_computeCallerForAccessor) ? (CallerImpl)new CallerImpl.FieldSetter.BoundJvmStaticInObject(field, KotlinKPropertyKt.computeCallerForAccessor$isNotNullProperty(property)) : (CallerImpl)new CallerImpl.FieldSetter.JvmStaticInObject(field, KotlinKPropertyKt.computeCallerForAccessor$isNotNullProperty(property)))) : ($isGetter ? (CallerImpl)new CallerImpl.FieldGetter.Static(field) : (CallerImpl)new CallerImpl.FieldSetter.Static(field, KotlinKPropertyKt.computeCallerForAccessor$isNotNullProperty(property))));
    }
}

