/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.SpecialJvmAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBinaryClassAnnotationLoader<A, S extends AnnotationsContainer<? extends A>>
implements AnnotationLoader<A> {
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;

    public AbstractBinaryClassAnnotationLoader(@NotNull KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        this.kotlinClassFinder = kotlinClassFinder;
    }

    @NotNull
    protected abstract S getAnnotationsContainer(@NotNull KotlinJvmBinaryClass var1);

    @Nullable
    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId var1, @NotNull SourceElement var2, @NotNull List<A> var3);

    @NotNull
    protected abstract A loadTypeAnnotation(@NotNull ProtoBuf.Annotation var1, @NotNull NameResolver var2);

    @Nullable
    protected final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<A> result2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (SpecialJvmAnnotations.INSTANCE.getSPECIAL_ANNOTATIONS().contains(annotationClassId)) {
            return null;
        }
        return this.loadAnnotation(annotationClassId, source, result2);
    }

    private final KotlinJvmBinaryClass toBinaryClass(ProtoContainer.Class $this$toBinaryClass) {
        SourceElement sourceElement = $this$toBinaryClass.getSource();
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
        return kotlinJvmBinarySourceElement != null ? kotlinJvmBinarySourceElement.getBinaryClass() : null;
    }

    @Nullable
    protected byte[] getCachedFileContent(@NotNull KotlinJvmBinaryClass kotlinClass2) {
        Intrinsics.checkNotNullParameter((Object)kotlinClass2, (String)"kotlinClass");
        return null;
    }

    @Override
    @NotNull
    public List<A> loadClassAnnotations(@NotNull ProtoContainer.Class container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.toBinaryClass(container);
        if (kotlinJvmBinaryClass == null) {
            throw new IllegalStateException(("Class for loading annotations is not found: " + container.debugFqName()).toString());
        }
        KotlinJvmBinaryClass kotlinClass2 = kotlinJvmBinaryClass;
        ArrayList result2 = new ArrayList(1);
        kotlinClass2.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, result2){
            final /* synthetic */ AbstractBinaryClassAnnotationLoader<A, S> this$0;
            final /* synthetic */ ArrayList<A> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return this.this$0.loadAnnotationIfNotSpecial(classId, source, (List)this.$result);
            }

            public void visitEnd() {
            }
        }, this.getCachedFileContent(kotlinClass2));
        return result2;
    }

    @Override
    @NotNull
    public List<A> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (kind == AnnotatedCallableKind.PROPERTY) {
            return this.loadPropertyAnnotations(container, (ProtoBuf.Property)proto, PropertyRelatedElement.PROPERTY);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, proto, container.getNameResolver(), container.getTypeTable(), kind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature2 = memberSignature;
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, container, signature2, false, false, null, false, 60, null);
    }

    @Override
    @NotNull
    public List<A> loadPropertyBackingFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        return this.loadPropertyAnnotations(container, proto, PropertyRelatedElement.BACKING_FIELD);
    }

    @Override
    @NotNull
    public List<A> loadPropertyDelegateFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        return this.loadPropertyAnnotations(container, proto, PropertyRelatedElement.DELEGATE_FIELD);
    }

    private final List<A> loadPropertyAnnotations(ProtoContainer container, ProtoBuf.Property proto, PropertyRelatedElement element) {
        Boolean bl = Flags.IS_CONST.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"IS_CONST.get(proto.flags)");
        boolean isConst = bl;
        boolean isMovedFromInterfaceCompanion = JvmProtoBufUtil.isMovedFromInterfaceCompanion(proto);
        if (element == PropertyRelatedElement.PROPERTY) {
            MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getPropertySignature$default(this, proto, container.getNameResolver(), container.getTypeTable(), false, true, false, 40, null);
            if (memberSignature == null) {
                return CollectionsKt.emptyList();
            }
            MemberSignature syntheticFunctionSignature = memberSignature;
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, container, syntheticFunctionSignature, true, false, isConst, isMovedFromInterfaceCompanion, 8, null);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getPropertySignature$default(this, proto, container.getNameResolver(), container.getTypeTable(), true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature fieldSignature = memberSignature;
        boolean isDelegated = StringsKt.contains$default((CharSequence)fieldSignature.getSignature(), (CharSequence)"$delegate", (boolean)false, (int)2, null);
        if (isDelegated != (element == PropertyRelatedElement.DELEGATE_FIELD)) {
            return CollectionsKt.emptyList();
        }
        return this.findClassAndLoadMemberAnnotations(container, fieldSignature, true, true, isConst, isMovedFromInterfaceCompanion);
    }

    @Override
    @NotNull
    public List<A> loadEnumEntryAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.EnumEntry proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        String string = container.getNameResolver().getString(proto.getName());
        String string2 = ((ProtoContainer.Class)container).getClassId().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"container as ProtoContai\u2026Class).classId.asString()");
        MemberSignature signature2 = MemberSignature.Companion.fromFieldNameAndDesc(string, ClassMapperLite.mapClass(string2));
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, container, signature2, false, false, null, false, 60, null);
    }

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer container, MemberSignature signature2, boolean property, boolean field, Boolean isConst, boolean isMovedFromInterfaceCompanion) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.findClassWithAnnotationsAndInitializers(container, this.getSpecialCaseContainerClass(container, property, field, isConst, isMovedFromInterfaceCompanion));
        if (kotlinJvmBinaryClass == null) {
            return CollectionsKt.emptyList();
        }
        KotlinJvmBinaryClass kotlinClass2 = kotlinJvmBinaryClass;
        List list = ((AnnotationsContainer)this.getAnnotationsContainer(kotlinClass2)).getMemberAnnotations().get(signature2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, ProtoContainer protoContainer, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findClassAndLoadMemberAnnotations");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = null;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return abstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations(protoContainer, memberSignature, bl, bl2, bl3, bl4);
    }

    @Override
    @NotNull
    public List<A> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite callableProto, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        MemberSignature methodSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, callableProto, container.getNameResolver(), container.getTypeTable(), kind, false, 16, null);
        if (methodSignature != null) {
            int index = parameterIndex + this.computeJvmParameterIndexShift(container, callableProto);
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, index);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, container, paramSignature, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    private final int computeJvmParameterIndexShift(ProtoContainer container, MessageLite message) {
        int n;
        MessageLite messageLite = message;
        if (messageLite instanceof ProtoBuf.Function) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Function)message) ? 1 : 0;
        } else if (messageLite instanceof ProtoBuf.Property) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Property)message) ? 1 : 0;
        } else if (messageLite instanceof ProtoBuf.Constructor) {
            Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.serialization.deserialization.ProtoContainer.Class");
            n = ((ProtoContainer.Class)container).getKind() == ProtoBuf.Class.Kind.ENUM_CLASS ? 2 : (((ProtoContainer.Class)container).isInner() ? 1 : 0);
        } else {
            throw new UnsupportedOperationException("Unsupported message: " + message.getClass());
        }
        return n;
    }

    @Override
    @NotNull
    public List<A> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        MemberSignature methodSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, proto, container.getNameResolver(), container.getTypeTable(), kind, false, 16, null);
        if (methodSignature != null) {
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, 0);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, container, paramSignature, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = proto.getExtension(JvmProtoBuf.typeAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.getExtension(JvmProtoBuf.typeAnnotation)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.loadTypeAnnotation((ProtoBuf.Annotation)it, nameResolver));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = proto.getExtension(JvmProtoBuf.typeParameterAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.getExtension(JvmPr\u2026.typeParameterAnnotation)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.loadTypeAnnotation((ProtoBuf.Annotation)it, nameResolver));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(@NotNull ProtoContainer container, @Nullable KotlinJvmBinaryClass specialCase) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = specialCase;
        if (kotlinJvmBinaryClass == null) {
            kotlinJvmBinaryClass = container instanceof ProtoContainer.Class ? this.toBinaryClass((ProtoContainer.Class)container) : null;
        }
        return kotlinJvmBinaryClass;
    }

    @Nullable
    protected final KotlinJvmBinaryClass getSpecialCaseContainerClass(@NotNull ProtoContainer container, boolean property, boolean field, @Nullable Boolean isConst, boolean isMovedFromInterfaceCompanion) {
        ProtoContainer.Class outerClass;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (property) {
            if (isConst == null) {
                boolean $i$a$-checkNotNull-AbstractBinaryClassAnnotationLoader$getSpecialCaseContainerClass$22 = false;
                String $i$a$-checkNotNull-AbstractBinaryClassAnnotationLoader$getSpecialCaseContainerClass$22 = "isConst should not be null for property (container=" + container + ')';
                throw new IllegalStateException($i$a$-checkNotNull-AbstractBinaryClassAnnotationLoader$getSpecialCaseContainerClass$22.toString());
            }
            if (container instanceof ProtoContainer.Class && ((ProtoContainer.Class)container).getKind() == ProtoBuf.Class.Kind.INTERFACE) {
                ClassId classId = ((ProtoContainer.Class)container).getClassId().createNestedClassId(Name.identifier("DefaultImpls"));
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"container.classId.create\u2026EFAULT_IMPLS_CLASS_NAME))");
                return KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId);
            }
            if (isConst.booleanValue() && container instanceof ProtoContainer.Package) {
                JvmClassName facadeClassName;
                SourceElement sourceElement = container.getSource();
                JvmPackagePartSource jvmPackagePartSource = sourceElement instanceof JvmPackagePartSource ? (JvmPackagePartSource)sourceElement : null;
                JvmClassName jvmClassName = facadeClassName = jvmPackagePartSource != null ? jvmPackagePartSource.getFacadeClassName() : null;
                if (facadeClassName != null) {
                    String string = facadeClassName.getInternalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"facadeClassName.internalName");
                    ClassId classId = ClassId.topLevel(new FqName(StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null)));
                    Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(facadeCl\u2026lName.replace('/', '.')))");
                    return KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId);
                }
            }
        }
        if (field && container instanceof ProtoContainer.Class && ((ProtoContainer.Class)container).getKind() == ProtoBuf.Class.Kind.COMPANION_OBJECT && (outerClass = ((ProtoContainer.Class)container).getOuterClass()) != null && (outerClass.getKind() == ProtoBuf.Class.Kind.CLASS || outerClass.getKind() == ProtoBuf.Class.Kind.ENUM_CLASS || isMovedFromInterfaceCompanion && (outerClass.getKind() == ProtoBuf.Class.Kind.INTERFACE || outerClass.getKind() == ProtoBuf.Class.Kind.ANNOTATION_CLASS))) {
            return this.toBinaryClass(outerClass);
        }
        if (container instanceof ProtoContainer.Package && container.getSource() instanceof JvmPackagePartSource) {
            SourceElement sourceElement = container.getSource();
            Intrinsics.checkNotNull((Object)sourceElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource");
            JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)sourceElement;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = jvmPackagePartSource.getKnownJvmBinaryClass();
            if (kotlinJvmBinaryClass == null) {
                kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, jvmPackagePartSource.getClassId());
            }
            return kotlinJvmBinaryClass;
        }
        return null;
    }

    @Nullable
    protected final MemberSignature getPropertySignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, boolean field, boolean synthetic, boolean requireHasFieldFlagForField) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"propertySignature");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature;
        if (field) {
            JvmMemberSignature.Field field2 = JvmProtoBufUtil.INSTANCE.getJvmFieldSignature(proto, nameResolver, typeTable, requireHasFieldFlagForField);
            if (field2 == null) {
                return null;
            }
            JvmMemberSignature.Field fieldSignature = field2;
            return MemberSignature.Companion.fromJvmMemberSignature(fieldSignature);
        }
        if (synthetic && signature2.hasSyntheticMethod()) {
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature2.getSyntheticMethod();
            Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"signature.syntheticMethod");
            return MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
        }
        return null;
    }

    public static /* synthetic */ MemberSignature getPropertySignature$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPropertySignature");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        return abstractBinaryClassAnnotationLoader.getPropertySignature(property, nameResolver, typeTable, bl, bl2, bl3);
    }

    @Nullable
    protected final MemberSignature getCallableSignature(@NotNull MessageLite proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull AnnotatedCallableKind kind, boolean requireHasFieldFlagForField) {
        MemberSignature memberSignature;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        MessageLite messageLite = proto;
        if (messageLite instanceof ProtoBuf.Constructor) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)proto, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(method);
        } else if (messageLite instanceof ProtoBuf.Function) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)proto, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(method);
        } else if (messageLite instanceof ProtoBuf.Property) {
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)proto;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"propertySignature");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (jvmPropertySignature == null) {
                return null;
            }
            JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    if (signature2.hasGetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature2.getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"signature.getter");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 2: {
                    if (signature2.hasSetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature2.getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"signature.setter");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 3: {
                    memberSignature = this.getPropertySignature((ProtoBuf.Property)proto, nameResolver, typeTable, true, true, requireHasFieldFlagForField);
                    break;
                }
                default: {
                    memberSignature = null;
                    break;
                }
            }
        } else {
            memberSignature = null;
        }
        return memberSignature;
    }

    public static /* synthetic */ MemberSignature getCallableSignature$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCallableSignature");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return abstractBinaryClassAnnotationLoader.getCallableSignature(messageLite, nameResolver, typeTable, annotatedCallableKind, bl);
    }

    protected final boolean isImplicitRepeatableContainer(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (classId.getOuterClassId() == null || !Intrinsics.areEqual((Object)classId.getShortClassName().asString(), (Object)"Container")) {
            return false;
        }
        KotlinJvmBinaryClass klass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId);
        return klass != null && SpecialJvmAnnotations.INSTANCE.isAnnotatedWithContainerMetaAnnotation(klass);
    }

    private static final class PropertyRelatedElement
    extends Enum<PropertyRelatedElement> {
        public static final /* enum */ PropertyRelatedElement PROPERTY = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement BACKING_FIELD = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement DELEGATE_FIELD = new PropertyRelatedElement();
        private static final /* synthetic */ PropertyRelatedElement[] $VALUES;

        public static PropertyRelatedElement[] values() {
            return (PropertyRelatedElement[])$VALUES.clone();
        }

        public static PropertyRelatedElement valueOf(String value) {
            return Enum.valueOf(PropertyRelatedElement.class, value);
        }

        static {
            $VALUES = propertyRelatedElementArray = new PropertyRelatedElement[]{PropertyRelatedElement.PROPERTY, PropertyRelatedElement.BACKING_FIELD, PropertyRelatedElement.DELEGATE_FIELD};
        }
    }

    public static abstract class AnnotationsContainer<A> {
        @NotNull
        public abstract Map<MemberSignature, List<A>> getMemberAnnotations();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotatedCallableKind.values().length];
            nArray[AnnotatedCallableKind.PROPERTY_GETTER.ordinal()] = 1;
            nArray[AnnotatedCallableKind.PROPERTY_SETTER.ordinal()] = 2;
            nArray[AnnotatedCallableKind.PROPERTY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

