/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorBasedTypeSignatureMappingKt {
    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter;
        T jvmType;
        Object builtInType;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
        Intrinsics.checkNotNullParameter(writeGenericType, (String)"writeGenericType");
        KotlinType kotlinType2 = typeMappingConfiguration.preprocessType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType kotlinType3;
            KotlinType newType = kotlinType3 = kotlinType2;
            boolean bl = false;
            return DescriptorBasedTypeSignatureMappingKt.mapType(newType, factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        Object object = SimpleClassicTypeSystemContext.INSTANCE;
        SimpleClassicTypeSystemContext $this$mapType_u24lambda_u2d1 = object;
        boolean bl = false;
        kotlinType2 = TypeSignatureMappingKt.mapBuiltInType($this$mapType_u24lambda_u2d1, kotlinType, factory, mode);
        if (kotlinType2 != null) {
            builtInType = object = kotlinType2;
            boolean bl2 = false;
            Object jvmType2 = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke((Object)kotlinType, jvmType2, (Object)mode);
            return (T)jvmType2;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            builtInType = ((IntersectionTypeConstructor)constructor).getAlternativeType();
            Object intersectionType = builtInType == null ? typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes()) : builtInType;
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)intersectionType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        Object bl2 = constructor.getDeclarationDescriptor();
        if (bl2 == null) {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"no descriptor for type constructor of ", (Object)kotlinType));
        }
        Object descriptor2 = builtInType = bl2;
        if (ErrorUtils.isError((DeclarationDescriptor)descriptor2)) {
            jvmType = factory.createObjectType("error/NonExistentClass");
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)descriptor2);
            bl2 = descriptorTypeWriter;
            if (bl2 != null) {
                ((JvmDescriptorTypeWriter)bl2).writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType jvmType2 = memberProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)jvmType2, (String)"memberProjection.type");
            KotlinType memberType = jvmType2;
            Object arrayElementType = null;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter2 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter2 != null) {
                    JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter3;
                    JvmDescriptorTypeWriter<T> $this$mapType_u24lambda_u2d3 = jvmDescriptorTypeWriter3 = jvmDescriptorTypeWriter2;
                    boolean bl3 = false;
                    $this$mapType_u24lambda_u2d3.writeArrayType();
                    $this$mapType_u24lambda_u2d3.writeClass(arrayElementType);
                    $this$mapType_u24lambda_u2d3.writeArrayEnd();
                }
            } else {
                Object object2 = descriptorTypeWriter;
                if (object2 != null) {
                    ((JvmDescriptorTypeWriter)object2).writeArrayType();
                }
                object2 = memberProjection.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"memberProjection.projectionKind");
                arrayElementType = DescriptorBasedTypeSignatureMappingKt.mapType(memberType, factory, mode.toGenericArgumentMode((Variance)((Object)object2), true), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                object2 = descriptorTypeWriter;
                if (object2 != null) {
                    ((JvmDescriptorTypeWriter)object2).writeArrayEnd();
                }
            }
            return factory.createFromString(Intrinsics.stringPlus((String)"[", (Object)factory.toString(arrayElementType)));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Object object3;
            KotlinType expandedType;
            if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)descriptor2) && !mode.getNeedInlineClassWrapping() && (expandedType = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, kotlinType)) != null) {
                return DescriptorBasedTypeSignatureMappingKt.mapType(expandedType, factory, mode.wrapInlineClassesMode(), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                object3 = factory.getJavaLangClassType();
            } else {
                ClassDescriptor arrayElementType = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)arrayElementType, (String)"descriptor.original");
                jvmDescriptorTypeWriter = typeMappingConfiguration.getPredefinedTypeForClass(arrayElementType);
                if (jvmDescriptorTypeWriter == null) {
                    boolean bl4 = false;
                    ClassDescriptor enumClassIfEnumEntry = ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY ? (ClassDescriptor)((ClassDescriptor)descriptor2).getContainingDeclaration() : (ClassDescriptor)descriptor2;
                    ClassDescriptor classDescriptor = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"enumClassIfEnumEntry.original");
                    object3 = factory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration));
                } else {
                    object3 = jvmDescriptorTypeWriter;
                }
            }
            jvmType = object3;
            writeGenericType.invoke((Object)kotlinType, jvmType, (Object)mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            jvmDescriptorTypeWriter = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2);
            Object object4 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)((Object)jvmDescriptorTypeWriter), factory, mode, typeMappingConfiguration, null, object4);
            jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                object4 = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue(object4, (String)"descriptor.getName()");
                jvmDescriptorTypeWriter.writeTypeVariable((Name)object4, (T)type2);
            }
            return (T)type2;
        }
        if (descriptor2 instanceof TypeAliasDescriptor && mode.getMapTypeAliases()) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)descriptor2).getExpandedType(), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unknown type ", (Object)kotlinType));
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration) {
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
        String string = typeMappingConfiguration.getPredefinedFullInternalNameForClass(klass);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean classDescriptor2 = false;
            return it;
        }
        DeclarationDescriptor declarationDescriptor = klass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"klass.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        String it = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"safeIdentifier(klass.name).identifier");
        String name = it;
        if (container instanceof PackageFragmentDescriptor) {
            String string3;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                string3 = name;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String classDescriptor2 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"fqName.asString()");
                string3 = stringBuilder.append(StringsKt.replace$default((String)classDescriptor2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('/').append(name).toString();
            }
            return string3;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2 = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
        if (classDescriptor2 == null) {
            throw new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor2;
        String string4 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        String containerInternalName = string4 == null ? DescriptorBasedTypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration) : string4;
        return containerInternalName + '$' + name;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

