/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JvmMemberSignature {
    private JvmMemberSignature() {
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDesc();

    @NotNull
    public final String toString() {
        return this.asString();
    }

    @NotNull
    public abstract String asString();

    public /* synthetic */ JvmMemberSignature(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Method
    extends JvmMemberSignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        public Method(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(null);
            this.name = name;
            this.desc = desc;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getDesc() {
            return this.desc;
        }

        @Override
        @NotNull
        public String asString() {
            return Intrinsics.stringPlus((String)this.getName(), (Object)this.getDesc());
        }

        public int hashCode() {
            int result2 = this.getName().hashCode();
            result2 = result2 * 31 + this.getDesc().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method method = (Method)other;
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)method.getName())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.getDesc(), (Object)method.getDesc());
        }
    }

    public static final class Field
    extends JvmMemberSignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        public Field(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(null);
            this.name = name;
            this.desc = desc;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getDesc() {
            return this.desc;
        }

        @Override
        @NotNull
        public String asString() {
            return this.getName() + ':' + this.getDesc();
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        @NotNull
        public final String component2() {
            return this.getDesc();
        }

        public int hashCode() {
            int result2 = this.getName().hashCode();
            result2 = result2 * 31 + this.getDesc().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field field = (Field)other;
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)field.getName())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.getDesc(), (Object)field.getDesc());
        }
    }
}

