/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

public final class TypeSubstitutionKt {
    @JvmOverloads
    @NotNull
    public static final KotlinType replace(@NotNull KotlinType $receiver, @NotNull List<? extends TypeProjection> newArguments, @NotNull Annotations newAnnotations) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(newArguments, (String)"newArguments");
        Intrinsics.checkParameterIsNotNull((Object)newAnnotations, (String)"newAnnotations");
        if ((newArguments.isEmpty() || newArguments == $receiver.getArguments()) && newAnnotations == $receiver.getAnnotations()) {
            return $receiver;
        }
        UnwrappedType unwrapped = $receiver.unwrap();
        UnwrappedType unwrappedType = unwrapped;
        if (unwrappedType instanceof FlexibleType) {
            kotlinType = KotlinTypeFactory.flexibleType(TypeSubstitutionKt.replace(((FlexibleType)unwrapped).getLowerBound(), newArguments, newAnnotations), TypeSubstitutionKt.replace(((FlexibleType)unwrapped).getUpperBound(), newArguments, newAnnotations));
        } else if (unwrappedType instanceof SimpleType) {
            kotlinType = TypeSubstitutionKt.replace((SimpleType)unwrapped, newArguments, newAnnotations);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kotlinType;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType replace$default(KotlinType kotlinType, List list, Annotations annotations2, int n, Object object) {
        if ((n & 1) != 0) {
            list = kotlinType.getArguments();
        }
        if ((n & 2) != 0) {
            annotations2 = kotlinType.getAnnotations();
        }
        return TypeSubstitutionKt.replace(kotlinType, list, annotations2);
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType replace(@NotNull SimpleType $receiver, @NotNull List<? extends TypeProjection> newArguments, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(newArguments, (String)"newArguments");
        Intrinsics.checkParameterIsNotNull((Object)newAnnotations, (String)"newAnnotations");
        if (newArguments.isEmpty() && newAnnotations == $receiver.getAnnotations()) {
            return $receiver;
        }
        if (newArguments.isEmpty()) {
            return $receiver.replaceAnnotations(newAnnotations);
        }
        return KotlinTypeFactory.simpleType(newAnnotations, $receiver.getConstructor(), newArguments, $receiver.isMarkedNullable());
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType replace$default(SimpleType simpleType2, List list, Annotations annotations2, int n, Object object) {
        if ((n & 1) != 0) {
            list = simpleType2.getArguments();
        }
        if ((n & 2) != 0) {
            annotations2 = simpleType2.getAnnotations();
        }
        return TypeSubstitutionKt.replace(simpleType2, list, annotations2);
    }

    @NotNull
    public static final SimpleType asSimpleType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (!(unwrappedType instanceof SimpleType)) {
            unwrappedType = null;
        }
        SimpleType simpleType2 = (SimpleType)unwrappedType;
        if (simpleType2 == null) {
            String string = "This is should be simple type: " + $receiver;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return simpleType2;
    }
}

