/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegatingFlexibleType
extends DelegatingType
implements Flexibility {
    private boolean assertionsDone;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeFactory factory;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;
    public static final Companion Companion;

    private final void runAssertions() {
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound()) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    protected abstract KotlinType getDelegateType();

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, Flexibility.class) || Intrinsics.areEqual(clazz, SubtypingRepresentatives.class)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = delegatingFlexibleType;
        } else {
            typeCapability = super.getCapability(capabilityClass);
        }
        return (T)typeCapability;
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        FlexibleTypeFactory flexibleTypeFactory = this.getFactory();
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return flexibleTypeFactory.create(kotlinType, kotlinType2);
    }

    @Override
    @NotNull
    protected final KotlinType getDelegate() {
        this.runAssertions();
        return this.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeFactory getFactory() {
        return this.factory;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.factory = factory;
    }

    static {
        Companion = new Companion(null);
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

