/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class DynamicTypeFactory
implements FlexibleTypeFactory {
    public static final DynamicTypeFactory INSTANCE;

    @Override
    @NotNull
    public String getId() {
        return "kotlin.DynamicType";
    }

    @Override
    @NotNull
    public KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        if (KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(lowerBound, TypeUtilsKt.getBuiltIns(lowerBound).getNothingType()) && KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(upperBound, TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType())) {
            return new Impl(lowerBound, upperBound);
        }
        throw (Throwable)new IllegalStateException("Illegal type range for dynamic type: " + lowerBound + ".." + upperBound);
    }

    private DynamicTypeFactory() {
        INSTANCE = this;
    }

    static {
        new DynamicTypeFactory();
    }

    private static final class Impl
    extends DelegatingFlexibleType {
        @Override
        @NotNull
        protected KotlinType getDelegateType() {
            return this.getUpperBound();
        }

        @Override
        @NotNull
        public Flexibility.SpecificityRelation getSpecificityRelationTo(@NotNull KotlinType otherType) {
            Intrinsics.checkParameterIsNotNull((Object)otherType, (String)"otherType");
            return !DynamicTypesKt.isDynamic(otherType) ? Flexibility.SpecificityRelation.LESS_SPECIFIC : Flexibility.SpecificityRelation.DONT_KNOW;
        }

        @Override
        @NotNull
        public KotlinType makeNullableAsSpecified(boolean nullable2) {
            return DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(this.getDelegateType()));
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }

        public Impl(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound) {
            Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
            super(lowerBound, upperBound, INSTANCE);
        }
    }
}

