/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeFactory flexibleTypeFactory = this.c.getComponents().getFlexibleTypeFactory();
            if (Intrinsics.areEqual((Object)flexibleTypeFactory.getId(), (Object)id) ^ true) {
                KotlinType kotlinType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto, null, 4, null) + ": " + ("Unexpected flexible type factory. Expected: " + flexibleTypeFactory.getId() + " Actual: " + id));
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorTy\u2026Factory.id} Actual: $id\")");
                return kotlinType;
            }
            KotlinType kotlinType = new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            return flexibleTypeFactory.create(kotlinType, new DeserializedType(this.c, type2, null, 4, null));
        }
        return new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        if (proto.hasClassName()) {
            annotated = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
                annotated = this.c.getComponents().getNotFoundClasses().get(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            annotated = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (annotated == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("Unknown type parameter " + proto.getTypeParameter()).getConstructor();
                annotated = typeConstructor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorTy\u2026eParameter}\").constructor");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v5;
            String name;
            DeclarationDescriptor container;
            block14: {
                List<TypeParameterDescriptor> list;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    List<TypeParameterDescriptor> list2 = ((ClassDescriptor)container).getTypeConstructor().getParameters();
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"container.typeConstructor.parameters");
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    List<TypeParameterDescriptor> list3 = ((CallableDescriptor)container).getTypeParameters();
                    list = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"container.typeParameters");
                } else {
                    list = CollectionsKt.emptyList();
                }
                List<TypeParameterDescriptor> typeParameters = list;
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v5 = t;
                    break block14;
                }
                v5 = null;
            }
            if ((annotated = (parameter = (TypeParameterDescriptor)v5)) == null || (annotated = annotated.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorType("Deserialized type parameter " + name + " in " + container).getConstructor();
                annotated = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"ErrorUtils.createErrorTy\u2026 $container\").constructor");
            }
        } else {
            TypeConstructor typeConstructor4 = ErrorUtils.createErrorType("Unknown type").getConstructor();
            annotated = typeConstructor4;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor4, (String)"ErrorUtils.createErrorTy\u2026nknown type\").constructor");
        }
        return annotated;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Annotated annotated = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull((Object)typeArgumentProto, (String)"typeArgumentProto");
        if (Intrinsics.areEqual((Object)typeArgumentProto.getProjection(), (Object)ProtoBuf.Type.Argument.Projection.STAR)) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)projection, (String)"typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map2;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map2 = MapsKt.emptyMap();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        int index = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        Map map3 = result;
                        Integer n = proto.getId();
                        DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index);
                        map3.put(n, deserializedTypeParameterDescriptor);
                    }
                    map2 = result;
                }
                return map2;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

