/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.AnnotatedElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.reflect.IllegalCallableAccessException;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.components.RuntimeSourceElementFactory;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0080\b\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u0004\u0018\u00010\u000bH\u0000\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u000bH\u0000\u001a\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011*\u00020\u0012H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0013"}, d2={"JVM_STATIC", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_STATIC", "()Lorg/jetbrains/kotlin/name/FqName;", "reflectionCall", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asKCallableImpl", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "", "asKFunctionImpl", "Lkotlin/reflect/jvm/internal/KFunctionImpl;", "asKPropertyImpl", "Lkotlin/reflect/jvm/internal/KPropertyImpl;", "toJavaClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-reflection"})
public final class UtilKt {
    @NotNull
    private static final FqName JVM_STATIC = new FqName("kotlin.jvm.JvmStatic");

    @NotNull
    public static final FqName getJVM_STATIC() {
        return JVM_STATIC;
    }

    @Nullable
    public static final Class<?> toJavaClass(@NotNull ClassDescriptor $receiver) {
        AnnotatedElement annotatedElement;
        SourceElement source;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SourceElement sourceElement = source = $receiver.getSource();
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            if (kotlinJvmBinaryClass == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClass");
            }
            annotatedElement = ((ReflectKotlinClass)kotlinJvmBinaryClass).getKlass();
        } else if (sourceElement instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
            ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)source).getJavaElement();
            if (reflectJavaElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.reflect.ReflectJavaClass");
            }
            annotatedElement = ((ReflectJavaClass)reflectJavaElement).getElement();
        } else {
            annotatedElement = null;
        }
        return annotatedElement;
    }

    public static final <R> R reflectionCall(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new IllegalCallableAccessException(e);
        }
        return (R)object;
    }

    @Nullable
    public static final KFunctionImpl asKFunctionImpl(@Nullable Object $receiver) {
        KFunctionImpl kFunctionImpl;
        Object object = $receiver;
        if (!(object instanceof KFunctionImpl)) {
            object = null;
        }
        if ((kFunctionImpl = (KFunctionImpl)object) == null) {
            Object object2 = $receiver;
            if (!(object2 instanceof FunctionReference)) {
                object2 = null;
            }
            FunctionReference functionReference = (FunctionReference)object2;
            Object object3 = functionReference != null ? functionReference.compute() : null;
            if (!(object3 instanceof KFunctionImpl)) {
                object3 = null;
            }
            kFunctionImpl = (KFunctionImpl)object3;
        }
        return kFunctionImpl;
    }

    @Nullable
    public static final KPropertyImpl<?> asKPropertyImpl(@Nullable Object $receiver) {
        KPropertyImpl kPropertyImpl;
        Object object = $receiver;
        if (!(object instanceof KPropertyImpl)) {
            object = null;
        }
        if ((kPropertyImpl = (KPropertyImpl)object) == null) {
            Object object2 = $receiver;
            if (!(object2 instanceof PropertyReference)) {
                object2 = null;
            }
            PropertyReference propertyReference = (PropertyReference)object2;
            Object object3 = propertyReference != null ? propertyReference.compute() : null;
            if (!(object3 instanceof KPropertyImpl)) {
                object3 = null;
            }
            kPropertyImpl = (KPropertyImpl)object3;
        }
        return kPropertyImpl;
    }

    @Nullable
    public static final KCallableImpl<?> asKCallableImpl(@Nullable Object $receiver) {
        KCallableImpl kCallableImpl;
        KCallableImpl kCallableImpl2;
        Object object = $receiver;
        if (!(object instanceof KCallableImpl)) {
            object = null;
        }
        if ((kCallableImpl2 = (KCallableImpl)object) == null) {
            kCallableImpl2 = kCallableImpl = (KCallableImpl)UtilKt.asKFunctionImpl($receiver);
        }
        if (kCallableImpl2 == null) {
            kCallableImpl = UtilKt.asKPropertyImpl($receiver);
        }
        return kCallableImpl;
    }
}

