/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.getPackageFqName()");
        Object object = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(object instanceof DeserializedPackageFragment)) {
            object = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)object;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        InputStream inputStream = (InputStream)this.loadResource.invoke((Object)this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        NameResolver nameResolver = packageFragment.getNameResolver();
        ProtoBuf.Class clazz = ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getExtensionRegistry());
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"ProtoBuf.Class.parseFrom\u2026ePaths.extensionRegistry)");
        ClassData classData = new ClassData(nameResolver, clazz);
        return new ClassDataWithSource(classData, null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull((Object)serializedResourcePaths, (String)"serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, (String)"loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

